#include <QtTest>
#include <QCoreApplication>
#include "control.h"
#include "jsonfactory.h"
#include "tools.h"
#include <QDebug>

// add necessary includes here

class TestSimphony : public QObject
{
    Q_OBJECT

public:
    TestSimphony();
    ~TestSimphony();
    Control control;
    char outdata[2048];

private slots:
    void initTestCase();
    void cleanupTestCase();
    void test_InitPOSReqJsonObj_data();
    void test_InitPOSReqJsonObj();
};

TestSimphony::TestSimphony()
{
}

TestSimphony::~TestSimphony()
{
}

void TestSimphony::initTestCase()
{
    memset(outdata, 0, 1024);
}

void TestSimphony::cleanupTestCase()
{

}

void TestSimphony::test_InitPOSReqJsonObj_data()
{
    QTest::addColumn<QByteArray>("indata");
    QTest::addColumn<QJsonObject>("result");
    QTest::addColumn<int>("reqType");
    QTest::addColumn<QStringList>("reqList");

    QMap<ReqType, QString> apiMaps;
    apiMaps[sign] = "sign";
    apiMaps[finds] = "finds";
    apiMaps[endday] = "end";
//    apiMaps[pay] = "pay";
//    apiMaps[refund] = "refund";

    for(QMap<ReqType,QString>::ConstIterator it=apiMaps.begin(); it!=apiMaps.end(); it++)
    {
        bool isOk = true;
        QFile indataFile(QString(":/testdata/simphony/%1.txt").arg(it.value()));
        QFile resultFile(QString(":/testdata/simphony/%1_r.txt").arg(it.value()));
        QByteArray indata, resultData;
        if((isOk &= indataFile.open(QIODevice::ReadOnly))) {
            indata = indataFile.readAll();
        }
        if((isOk &= resultFile.open(QIODevice::ReadOnly))) {
            resultData = resultFile.readAll();
        }

        QStringList reqList;
        switch ((ReqType)it.key()) {
        case finds:
            reqList << "2017-09-01 00:00:00" << "2017-09-01 10:50:07" << "1";
            break;
        case pay:
            reqList << "287303528213597599";
        default:
            break;
        }
        if(isOk) {
            QTest::newRow(it.value().toLocal8Bit().data()) << indata << QJsonDocument::fromJson(resultData).object() << (int)it.key() << reqList;
        }
        indataFile.close();
        resultFile.close();
    }
}

void TestSimphony::test_InitPOSReqJsonObj()
{
    QFETCH(QByteArray, indata);
    QFETCH(QJsonObject, result);
    QFETCH(int, reqType);
    QFETCH(QStringList, reqList);

    control.InitPOSReqJsonObj(QString::fromUtf8(indata).toUtf8().data());
    qDebug() << "Pos req json obj: " << control._posReqJsonObj;
    QJsonObject json;
    JsonFactory::GetJsonWithType((ReqType)reqType, json, control._posReqJsonObj, reqList);

    qDebug() << "Send to server: " << json;

    QString error;
    QByteArray serverRetData;

    QJsonObject resultJson;
    bool isOk = false;
    if((ReqType)reqType == sign)
    {
        isOk = control.GetRSA(error);
        if(isOk) {
            control.SetResPonseWithMessage("100", QString::fromUtf8("签名成功"));
        } else {
            control.SetResPonseWithMessage("22", QString::fromUtf8("签名失败"));
        }
        resultJson = control._responseJsonObj;
    } else {
        isOk = control.SendMessageToServer(json, serverRetData, error);
        if(isOk) {
            if(reqType==finds||reqType==endday) {
                resultJson = QJsonDocument::fromJson(serverRetData).object();
            } else {
                control.GetJson((ReqType)reqType, resultJson, serverRetData, error);
            }
        }
    }
    if(!isOk) {
        qDebug() << "Is not ok: " << error;
    }

    QVERIFY(isOk);

    qDebug() << "Expect json: " << result;
    qDebug() << "Result json: " << resultJson;

    QCOMPARE(resultJson["statusCode"].toInt(), 100);
}

QTEST_MAIN(TestSimphony)

#include "tst_testsimphony.moc"
