﻿#include "fmp_settings.h"
#include "global.h"
#include "DataProcess/tools.h"
#include <QSettings>
#include <QDebug>

/**
 * @brief The FMPSettings class
 */
FMPSettings::FMPSettings(QObject *parent)
    : QObject(parent),
      d_ptr(new FMPSettingsPrivate(parent))
{
}

FMPSettings::~FMPSettings()
{
    if (d_ptr) {
        delete d_ptr;
        d_ptr = nullptr;
    }
}

QVariant FMPSettings::GetValue(const QString &k, QVariant default_val)
{
    Q_D(FMPSettings);

    return d->GetValue(k, default_val);
}

bool FMPSettings::SetValue(const QString &k, QVariant v)
{
    Q_D(FMPSettings);

    return d->SetValue(k, v);
}

/**
 ***************************************************************
 */
FMPSettingsPrivate::FMPSettingsPrivate(QObject *parent)
    : QObject(parent)
{
    char path[MAX_PATH] = {0};
    ToolS::GetProcPath(path);
    _sets = new QSettings(QString::fromLocal8Bit("%1/%2").arg(path).arg(USERCONFIG_NAME), QSettings::IniFormat);
}

QVariant FMPSettingsPrivate::GetValue(const QString &k, QVariant default_val)
{
    return _sets->value(k, default_val);
}

bool FMPSettingsPrivate::SetValue(const QString &k, QVariant v)
{
    _sets->setValue(k, v);
    return (_sets->value(k) == v);
}
