﻿#include "control.h"
#include "global.h"
#include "fmtool.h"
#include "fmerror.h"
#include "QsLog.h"
#include "jsonfactory.h"
#include "rspfactory.h"
#include <QSemaphore>
#include <QtConcurrent>
#include <QSettings>
#include <QJsonObject>
#include <QEventLoop>
#include <QFont>
#include <QFontDatabase>
#include <QApplication>
#include <QSslSocket>
#include <QSslConfiguration>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QJsonDocument>
#include <Windows.h>
#include "DataProcess/tools.h"
#include "DataProcess/cretopt.h"
#include "DataProcess/fmnetwork.h"

EXTERN_C IMAGE_DOS_HEADER __ImageBase;

typedef int (__stdcall *SKBAPISend)(const char *indata, const char *guid, char *outdata, char *errMsg, const char *mode, const char *operation);

Control::Control(QObject *parent) : QObject(parent), _widget(NULL)
{
    QString path;
    ToolS::GetPath(path);

    _isinterrupt = false;
    _db = new FMPDataBase(path + DB_ORDER, QString("writeorder"));

    QString sql = QString("create table ") + DB_TABLE_NAME + " ("
                          "orderid varchar(60) primary key, "
                          "content text"
                          ")";

    QLOG_INFO() << "creat table : " << sql;

    _db->Init();
    _db->creat(sql);

    InitModel();
}

Control::~Control()
{
    if(_db != NULL)
    {
       delete _db;
       _db = NULL;
    }
}

void Control::Start(const char *indata, char *outdata)
{
    bool refundflag = false;
    QLOG_INFO() << "get data from pos:" << QString::fromLocal8Bit(indata);

    QString appPath;
    char pathStr[MAX_PATH] = { 0 };
    ToolS::GetProcPath(pathStr);
    appPath = QString::fromLocal8Bit(pathStr);
    appPath = appPath.replace("\\", "/");
    QFontDatabase::addApplicationFont(appPath + "/msyh.ttf");
    QFont ft("Microsoft YaHei UI Light");
    qApp->setFont(ft);

    QDir::setCurrent(appPath);
    QLOG_INFO() << "Openssl support:" << QSslSocket::supportsSsl();
    qDebug() << "Openssl support:" << QSslSocket::supportsSsl() << QApplication::libraryPaths();

    QEventLoop loop;

    if(_widget == NULL)
        _widget = new HostWidget();

    InitPOSReqJsonObj(indata);

    connect(_widget, &HostWidget::Interrupt, this, [this](){
        _isinterrupt = true;
    });

    connect(_widget, &HostWidget::RequestWithType, this, &Control::RequestWithType);

    connect(_widget, &HostWidget::Exits, this, [&loop, &refundflag] ()
    {
        QLOG_INFO() << "quit with normal";
        refundflag = true;
        loop.exit();
    });
    connect(_widget, &HostWidget::ExitWithMSG, this, [this, &loop] (QString code, QString message)
    {
        QLOG_INFO() << "quit with : " << message;
        SetResPonseWithMessage(code, message);
        loop.exit();
    });

//    QString reqtype;

//    reqtype.append(_request.TransType[0]).append(_request.TransType[1]);

//    _widget->ShowWithRequest(_request);


//    if(reqtype.compare("40") != 0)
//    {
//        loop.exec();
//    }else
//    {
//        if(reqtype.compare("40") == 0 && refundflag == false)
//            loop.exec();
//    }

//    _widget->ShowWithRequest(_request);
    _widget->ShowWithRequest(_posType, _posReqJsonObj);

    loop.exec();

    _lock.lock();
    delete _widget;
    _widget = NULL;
    _lock.unlock();

//    memcpy(outdata, (char *)(&_response), sizeof(struct AlipayResponse));
//    outdata[sizeof(struct AlipayResponse)] = 0;
    QByteArray responseArray = QJsonDocument(_responseJsonObj).toJson(QJsonDocument::Compact);
    char *rspData = responseArray.data();
    char tmpbuf[MAX_BUF_LEN] = { 0 };
    int len = FMTool::UTF8ToGBK((unsigned char *)rspData, (unsigned char *)tmpbuf, MAX_PRINT_LEN);

    memcpy((char *)outdata, tmpbuf, len);

    QLOG_INFO() << "return data to pos : " << QString::fromLocal8Bit(outdata);
}

void Control::InitPOSReqJsonObj(const char *indata)
{
    QJsonParseError parseError;
    QJsonDocument inDataDoc = QJsonDocument::fromJson(QString::fromLocal8Bit(indata).toUtf8(), &parseError);
    if(parseError.error == QJsonParseError::NoError) {
        _posReqJsonObj = inDataDoc.object();

        int type = FMTool::GetJsonValue(_posReqJsonObj, JSON_KEY_REQTYPE).toInt(SPCC_sign);

        if(type>=SPCC_sign && type<=SPCC_finds) {
            _posReqJsonObj[JSON_KEY_REQTYPE] = type - SPCC_sign;
            _posType = SPCC;
        } else if(type>=SIMPHONY_sign && type<=SIMPHONY_finds) {
            _posReqJsonObj[JSON_KEY_REQTYPE] = type - SIMPHONY_sign;
            _posType = SIMPHONY;
        } else {
            // TODO: Other type.
        }
    } else {
        qDebug() << "Json parse error: " << parseError.errorString();
        memcpy(&_request, indata, sizeof(struct AlipayRequest));
        ReqType type = (ReqType)(FMTool::GetString(_request.TransType, 2).toInt());
        JsonFactory::GetJsonWithType(type, _posReqJsonObj, _request);
        qDebug() << _posReqJsonObj;
        _posType = RES;
    }
}

void Control::SetResPonseWithMessage(QString code, const QString &message)
{
//    FMTool::SetString(_response.ResponseCode, 3, code);
//    FMTool::SetString(_response.ResponseMsg, 40, message);
    _responseJsonObj[JSON_KEY_STATUSCODE] = code.toInt();
    _responseJsonObj[JSON_KEY_MESSAGE] = message;
}

void Control::InitModel()
{
//    memset(&_request, ' ', sizeof(struct AlipayRequest));
//    memset(&_response, ' ', sizeof(struct AlipayResponse));
    _posReqJsonObj = QJsonObject();
    _responseJsonObj = QJsonObject();
}

bool Control::SendMessageToServer(const QJsonObject &json, QByteArray &outdata, QString &error)
{
    QJsonObject tmpjson = json;
    tmpjson[JSON_KEY_VER] = DEFAULT_JSON_VER_VALUE;
    CretOperate::GetMAC(tmpjson);
    CretOperate::GetSign(tmpjson);

    QLOG_INFO() << "send json to payment: " << tmpjson;
    qDebug() << "send json to payment: " << tmpjson;

    if(_posType==SPCC) {
        return SendMessageToSBKAPI(tmpjson, outdata, error);
    } else {
        return SendMessageToPayMent(tmpjson, outdata, error);
    }
    return false;
}

bool Control::SendMessageToPayMent(const QJsonObject &json, QByteArray &outdata, QString &error)
{
    QByteArray array;
    QString path;
    ToolS::GetPath(path);
    QString url = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_URL).toString();

    QLOG_INFO() << "send json to payment: " << json;

    QByteArray data = QJsonDocument(json).toJson(QJsonDocument::Compact);

#ifdef MOCK
    QEventLoop loop;
    QFuture<void> future = QtConcurrent::run( [ this, &loop, json, &array]()
    {
        QLOG_DEBUG() << "=========================================== Read debug data. ========================================";
        int type = FMTool::GetJsonValue(json, JSON_KEY_REQTYPE).toInt(sign);
        QLOG_DEBUG() << "Test req type: " << type;
        QFile f(qApp->applicationDirPath()+QString("/test_simphony/%1.txt").arg(type));
        f.open(QIODevice::ReadOnly);
        array = f.readAll();
        Sleep(1000*10);
        QLOG_DEBUG() << "=========================================== End read debug data. ====================================";
    });
    QFutureWatcher<void> watcher;
    watcher.setFuture(future);
    connect(&watcher, SIGNAL(finished()), &loop, SLOT(quit()));

    loop.exec();
#else
    if(!Control::HttpPost(url, array, data, "application/json;charset=utf-8", "application/json", error, 60))
    {
        if(json.contains(JSON_KEY_PARTORDERID) && !json[JSON_KEY_PARTORDERID].toString().isEmpty())
        {
            QVariantHash hash;

            hash.insert(SQL_KEY_ORDERID, json[JSON_KEY_PARTORDERID].toString());
            hash.insert(SQL_KET_CONTENT, QString(data));


            _db->insert(DB_TABLE_NAME, hash);
        }

        return false;
    }
#endif

    outdata = array;

    return true;
}

bool Control::HttpPost(QString url, QByteArray &outdata, const QByteArray &indata, QString content, QString accept, QString  &error, int timeout)
{
    QString path;
    ToolS::GetPath(path);

    QString host = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_HOST).toString();

    QEventLoop loop;
    QTimer timer;

    QSslConfiguration config = QSslConfiguration::defaultConfiguration();
    config.setPeerVerifyMode(QSslSocket::VerifyNone);

    QNetworkAccessManager manger;
    QNetworkRequest request(url);

    request.setSslConfiguration(config);

    request.setRawHeader("Content-Type", content.toUtf8());
    request.setRawHeader("Accept", accept.toUtf8());
    request.setRawHeader("Host", host.toUtf8());
    request.setRawHeader("Authorization", "Basic dXBzLWNsaWVudDo2VGk4TjBXNzRyb1A=");


    QNetworkReply* reply = manger.post(request, indata);

    connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
    connect(&manger, &QNetworkAccessManager::finished, &loop, &QEventLoop::quit);
    connect(_widget, &HostWidget::Interrupt, &loop, &QEventLoop::quit);
    connect(reply, static_cast<void (QNetworkReply::*)(QNetworkReply::NetworkError)>(&QNetworkReply::error), &loop, &QEventLoop::quit);
    timer.start(timeout*1000);

    loop.exec();

    reply->deleteLater();


    if(_isinterrupt)
    {
        error = QString::fromLocal8Bit("收款被取消");
        return false;
    }


    if(reply->error() != QNetworkReply::NoError)
    {
        error = QString::fromLocal8Bit("网络异常,获取服务端返回数据失败");
        QLOG_INFO() << reply->errorString() << "Contents: " << reply->readAll();
        return false;
    }

    outdata = reply->readAll();

    if(outdata.isEmpty())
    {
        error = QString::fromLocal8Bit("网络异常,获取服务端返回数据为空");
        QLOG_INFO() << reply->errorString() << "Contents: " << reply->readAll();
        return false;
    }

    QLOG_INFO() << outdata.data();

    return true;
}

bool Control::SendMessageToSBKAPI(const QJsonObject &json, QByteArray &outdata, QString &error)
{

    char mod[MAX_PATH] = { 0 };

    ToolS::GetProcPath(mod);

    QLibrary lib(QString(mod) + "\\" + "SBKAPIWrapper.dll");

    QLOG_INFO() << QString(mod) + "\\" + "SBKAPIWrapper.dll";

    if(lib.load())
    {
        SKBAPISend skbSend = (SKBAPISend)lib.resolve("Send");

        if(skbSend != NULL)
        {
            QEventLoop loop;
            QFuture<QByteArray> future = QtConcurrent::run( [ this, &loop, json, &error, skbSend]() ->QByteArray
            {
                QString reqXmlStr = QString::fromLocal8Bit("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
                                                             "<ns0:OLTP xmlns:ns0=\"http://spcc.com.cn/online\">"
                                                                 "<ns0:HEADER>"
                                                                    "<ns0:VER>%1</ns0:VER>"
                                                                 "<ns0:FROM>%2</ns0:FROM>"
                                                                    "<ns0:TERMINO>%3</ns0:TERMINO>"
                                                                    "<ns0:TO>%4</ns0:TO>"
                                                                    "<ns0:BUSINESS>%5</ns0:BUSINESS>"
                                                                    "<ns0:DATE>%6</ns0:DATE>"
                                                                    "<ns0:TIME>%7</ns0:TIME>"
                                                                    "<ns0:STATCODE>%8</ns0:STATCODE>"
                                                                    "<ns0:STATDESC/>"
                                                                "</ns0:HEADER>"
                                                                "<ns0:AP>"
                                                                    "%9"
                                                                "</ns0:AP>"
                                                            "</ns0:OLTP>");
                QString nsTo = "CS00400004";
                int type = FMTool::GetJsonValue(json, JSON_KEY_REQTYPE).toInt(sign);
                if(type==sign) {
                    nsTo = "CS00400003";
                }
                QString date = QDate::currentDate().toString("yyMMdd");
                QString time = QTime::currentTime().toString("hhmmss");
                QString storeId = FMTool::GetJsonValue(json, JSON_KEY_STOREID).toString();
                QString posId = FMTool::GetJsonValue(json, JSON_KEY_STATIONID).toString();

                qsrand(QDateTime::currentMSecsSinceEpoch());
                QString termino = QString::fromUtf8("%1%2%3%4%5").arg(date).arg(storeId, 6, '0').arg(posId, 6, '0').arg(qrand()%90+10).arg(time);

                QByteArray jsonArray = QJsonDocument(json).toJson(QJsonDocument::Compact);

                reqXmlStr = reqXmlStr.arg(_setting.GetValue(CONFIG_OLTP_VER, "01.01").toString())
                        .arg(_setting.GetValue(CONFIG_OLTP_FROM, "CS00000001").toString())
                        .arg(termino)
                        .arg(nsTo)
                        .arg(_setting.GetValue(CONFIG_OLTP_BUSINESS, "0000000").toString())
                        .arg(QDate::currentDate().toString("yyyyMMdd"))
                        .arg(time)
                        .arg(_setting.GetValue(CONFIG_OLTP_STATCODE, "0000").toString())
                        .arg(QString::fromUtf8(jsonArray));

                char in[MAX_BUF_LEN] = {0};
                char out[MAX_BUF_LEN] = {0};
                char *guid = "";
                char errMsg[MAX_BUF_LEN] = {0};
                QByteArray mode = _setting.GetValue(CONFIG_OLTP_MODE, "FM").toByteArray();
                QByteArray operation = _setting.GetValue(CONFIG_OLTP_OPERATION, "75000").toByteArray();

                strcpy(in, reqXmlStr.toUtf8().data());
                QLOG_INFO() << "Request StarbucksAPI XML data: " << in << "mode: " << mode << "Operation: " << operation;
#ifdef MOCK
                QLOG_DEBUG() << "=========================================== Read debug data. ========================================";
                QLOG_DEBUG() << "Test req type: " << type;
                QFile f(qApp->applicationDirPath()+QString("/test_spcc/%1.txt").arg(type));
                f.open(QIODevice::ReadOnly);
                strcpy(out, f.readAll().data());
//                Sleep(1000*10);
                QLOG_DEBUG() << "=========================================== End read debug data. ====================================";

                int result = 0;
#else
                int result = skbSend(in, guid, out, errMsg, mode.data(), operation.data());
#endif //! End def MOCK

                QLOG_DEBUG() << "StarbucksAPI return to GBK: " << QString::fromLocal8Bit(out);

                QString outXMlString = QString::fromLocal8Bit(out);

                QLOG_INFO() << "OLTP return:  " << result << " data: " << outXMlString;

                if(result!=0) {
                    error = "OLTP return error: \n" + QString::fromLocal8Bit(errMsg);
                    QLOG_ERROR() << error;
                    return QByteArray();
                } else {
                    QString statcode;
                    bool isOk = FMTool::SearchXMLNodeString(outXMlString, "ns0:STATCODE", statcode);
                    if(!isOk) {
                        error = "Can't find xml node: ns0:STATCODE";
                        QLOG_ERROR() << error;
                        return QByteArray();
                    }
                    if(statcode.compare("0000")!=0) {
                        error = "OLTP return STATCODE is: " + statcode;
                        QLOG_ERROR() << error;
                        return QByteArray();
                    }

                    QString returnStr;
                    isOk = FMTool::SearchXMLNodeString(outXMlString, "ns0:AP", returnStr);
                    if(!isOk) {
                        error = "Can't find xml node: ns0:AP";
                        QLOG_ERROR() << error;
                        return QByteArray();
                    }
                    return returnStr.toUtf8();
                }

                return QByteArray(out);
            });

            QFutureWatcher<QByteArray> watcher;
            watcher.setFuture(future);
            connect(&watcher, SIGNAL(finished()), &loop, SLOT(quit()));

            loop.exec();

            outdata = watcher.result();
            bool isEmpty = outdata.isNull() && outdata.isEmpty();
            return !isEmpty;
        }
        else
        {
            QLOG_ERROR() << "get function (Send) failed";
            error = QString::fromLocal8Bit("加载基础组件(fun)失败");
        }

    }
    else
    {
        QLOG_ERROR() << "load dll failed";
        error = QString::fromLocal8Bit("加载基础组件(dll)失败");
    }

    return false;
}

bool Control::GetRSA(QString &error)
{
    QJsonObject json;

    json.insert(JSON_KEY_VER, 1);
    json.insert(JSON_KEY_REQTYPE, sign);
    json.insert(JSON_KEY_STOREID, FMTool::GetJsonValue(_posReqJsonObj, JSON_KEY_STOREID).toString());
    json.insert(JSON_KEY_STATIONID, FMTool::GetJsonValue(_posReqJsonObj, JSON_KEY_STATIONID).toString());
    json.insert(JSON_KEY_PARTNERID, FMTool::GetJsonValue(_posReqJsonObj, JSON_KEY_PARTNERID).toInt());

    CretOperate::GetDES3MAC(json);
    QByteArray array;

    QLOG_INFO() << "get mac sign request : " << json;

    QString path;
    ToolS::GetPath(path);
    QString url = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_URL_CRET).toString();
    QByteArray data = QJsonDocument(json).toJson(QJsonDocument::Compact);

    if(_posType == SPCC)
    {
        if(!SendMessageToSBKAPI(json, array, error))
        {
            QLOG_ERROR() << "SendMessageToSBKAPI error: " << error;
            return false;
        }
    } else {
        if(!Control::HttpPost(url, array, data,"application/json;charset=utf-8", "application/json", error, 60))
        {
            QLOG_ERROR() << "httppos error :" << error;
            return false;
        }
    }

    if(CretOperate::SetRSACret(array) == 0)
    {
        error = QString::fromLocal8Bit("签名失败，请重新获取签名");
        return false;
    }

    return true;
}

void Control::RequestSign()
{
    QString error;
    bool rlt = GetRSA(error);

    if(rlt)
        SetResPonseWithMessage("100", QString::fromLocal8Bit("签名成功"));
    else
        SetResPonseWithMessage("22", QString::fromLocal8Bit("签名失败"));

    _lock.lock();
    if(_widget != NULL)
        _widget->ShowWiteMGS(sign, rlt, error);
    _lock.unlock();
}

bool Control::GetJson(ReqType type,QJsonObject &json, const QByteArray array, QString &error)
{
    QJsonParseError parseError;
    QJsonDocument jsonDocument = QJsonDocument::fromJson(array.data(), &parseError);

    if( jsonDocument.isNull() )
    {
        QLOG_ERROR() << "server return not json" << parseError.errorString();
        error = QString::fromLocal8Bit("服务端返回数据异常");
        return false;
    }

    json = jsonDocument.object();

    if(json.contains(JSON_KEY_MESSAGE) && json.contains(JSON_KEY_STATUSCODE) && (json[JSON_KEY_STATUSCODE].toInt() == 307 || json[JSON_KEY_STATUSCODE].toInt() == 303))
    {
        error = QString::fromLocal8Bit("签名过期，请重新获取签名");
        json.insert(JSON_KEY_MESSAGE, QString::fromLocal8Bit("签名过期，请重新获取签名"));
    }

    if(type == againprint)
        json.insert(JSON_KEY_FMID, _fmId);

    if(type == refund && json.contains(JSON_KEY_STATUSCODE) && json[JSON_KEY_STATUSCODE].toInt() == 100)
        json.insert(JSON_KET_CLIENTREF, FMTool::GetString(_request.Amount, 12));

//    RspFactory::GetResPonseJson(type, _response, json);
    RspFactory::GetResPonseJson(type, _responseJsonObj, json);

    if(json.contains(JSON_KEY_MESSAGE))
        error = json[JSON_KEY_MESSAGE].toString();

    if(json.contains(JSON_KEY_STATUSCODE) && json[JSON_KEY_STATUSCODE].toInt() == 100)
        return true;

    return false;
}

void Control::Request(ReqType type, QStringList list)
{
    QJsonObject json, rtjson;
    QString error;
    QByteArray outdata;

    if(type == againprint)
        _fmId = list[0];

    JsonFactory::GetJsonWithType(type, json, _posReqJsonObj, list);

    QJsonDocument(json).toJson(QJsonDocument::Compact);

    bool rlt = SendMessageToServer(json, outdata, error);

    if(rlt)
        rlt = Control::GetJson(type, rtjson, outdata, error);
    else
        SetResPonseWithMessage("23", error);

    _lock.lock();
    if(_widget != NULL && type == finds)
    {
        _widget->ShowWiteJson(rlt, rtjson, error);
    }
    else
    {
        _widget->ShowWiteMGS(type, rlt, error);
    }
    _lock.unlock();
}

void Control::RequestWithType(ReqType type, QStringList list)
{
    if(type == sign)
    {
        RequestSign();
        return ;
    }
    Request(type, list);
}

void Control::setIsinterrupt(bool isinterrupt)
{
    _isinterrupt = isinterrupt;
}
