#include "rollback.h"
#include "fmglobal.h"
#include <QSqlQuery>
#include <QEventLoop>
#include <QJsonDocument>
#include <QTimer>
#include <QSettings>
#include <QJsonObject>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
#include "tools.h"
#include "QsLog.h"
#include "cretopt.h"
#include "fmnetwork.h"
#include <QtConcurrent>

RollBack::RollBack(QObject *parent) : QThread(parent)
{
    //_db = new FMPDataBase(path + DB_ORDER, QString("rollback"));
}

RollBack::~RollBack()
{
    requestInterruption();
    wait();

//    if(_db != NULL)
//    {
//        delete _db;
//        _db = NULL;
//    }

}

void RollBack::RollWiteQuery(QSqlDatabase &_db, QSqlQuery &query)
{
    while(query.next())
    {
        QString parnetid = query.value(0).toString();
        QString content = query.value(1).toString();

        QJsonDocument jsonDocument = QJsonDocument::fromJson(content.toUtf8());

        if( jsonDocument.isNull() )
        {
            QString sql = QString("delete from orderlist where orderid='%1'").arg(parnetid);
            QLOG_ERROR() << sql;
            query.exec(sql);
        }

        QJsonObject json = jsonDocument.object();

        json.insert(JSON_KEY_REQTYPE, 3);

        if(!CretOperate::GetSign(json))
        {
            QLOG_ERROR() << "get sign error";
            continue;
        }

        QLOG_INFO() << json;

        QByteArray data = QJsonDocument(json).toJson(QJsonDocument::Compact);

        QByteArray array;

        QString path;
        QString error;
        ToolS::GetPath(path);

        qDebug() << "*****************************" << path;

        QString url = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_URL).toString();

        QLOG_INFO() << "roll back server url : " << url;

        if(FMNetWork::HttpPost(url, array, data, "application/json;charset=utf-8","application/json", error, 12))
        {
            QString sql = QString("delete from orderlist where orderid='%1'").arg(parnetid);
            QLOG_ERROR() << sql;
            query.exec(sql);
        }

        QLOG_WARN() << "rollback resulte " << QThread::currentThreadId() << ":" << array;

    }
}

void RollBack::run()
{
    QString path;
    ToolS::GetPath(path);

    QSqlDatabase _db = QSqlDatabase::addDatabase("QSQLITE", QString("backup"));
    _db.setDatabaseName(path + DB_ORDER);
    _db.open();

    while(!isInterruptionRequested())
    {
        int timeout = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_TIMEOUT).toInt();

        if(timeout == 0)
            timeout = 30;

        do
        {
            QSqlQuery query(_db);

            QLOG_WARN() << "find sql : " << "select * from orderlist";

            bool flag = query.exec("select * from orderlist");

            if(!flag)
                QLOG_WARN() << query.lastError();


            RollWiteQuery(_db, query);

        }while(0);

        QEventLoop loop;
        QTimer timer;
        connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
        timer.start(timeout*1000);

        loop.exec();
    }
}
