#ifndef XMLREADER_H
#define XMLREADER_H

#include <QObject>
#include <QDomDocument>
#include <QDomElement>

typedef QMap<QString, QString> Attributes;

class XMLReader : public QObject
{
    Q_OBJECT
public:
    explicit XMLReader(QObject *parent = nullptr);
    ~XMLReader();

    bool parser(const QString &xmlString);
    bool parserFile(const QString &xmlFile, QDomNode &root);

    QList<QDomNode> findElements(const QString &name);

    QList<QDomNode> findElementsByAttr(const QString &name, const Attributes &attr);

    QMap<QString, QList<QDomNode>> groupElementsByAttr(const QString &nodeName, const QString &attrName);

    Attributes getAttributes(const QDomNode &node);
    QString getAttributeValue(const QDomNode &node, const QString &attrName);
    bool checkAttributeValue(const QDomNode &node, const QString &attrName, const QString &attrValue);

    QString errorString;

    QDomDocument xmlDoc;
signals:

public slots:

private:
};

#endif // XMLREADER_H
