#ifndef LABELSTIMER_H
#define LABELSTIMER_H

#include <QWidget>
#include <QLabel>

class QTimer;

class LabelsTimer : public QObject
{
    Q_OBJECT
public:
    explicit LabelsTimer(QLabel *label, int time, QString format="%1");
    virtual ~LabelsTimer();

    void setLabel(QLabel *label);

    void start();
    void start(int time, QString format="%1");
    void stop();

signals:
    void timeout();
    void timeChanged(int time);

public slots:

private slots:
    void onTimeout();

private:
    QLabel *_label;
    QTimer *_timer;
    int _time;
    QString _format;
};

#endif // LABELSTIMER_H
