#ifndef HOSTWIDGET_H
#define HOSTWIDGET_H

#include "fmp_window.h"
#include "requestmodel.h"
#include <QWidget>
#include <QList>
#include <QTimer>
#include <QStringList>

class LabelsTimer;
class QMovie;

namespace Ui {
class HostWidget;
}

class HostWidget : public FMPWindow
{
    Q_OBJECT

public:

    explicit HostWidget(QWidget *parent = 0);

    ~HostWidget();

    void ShowWithRequest(AlipayRequest request);
    void ShowWithRequest(POSType posType, QJsonObject requestObj);

    void ShowWiteMGS(ReqType type, bool flag, QString message = QString());

    void ShowWiteJson(bool flag, QJsonObject object, QString error);

    void setRuning(bool runing);

    void StopPay();

    void HideExit();

signals:

    void RequestWithType(ReqType type, QStringList list);

    void ExitWithMSG(QString code, QString message);

    void Exits();

    //ж
    void Interrupt();

protected:
    void keyPressEvent(QKeyEvent *ke);

private slots:
    void on_btn_printagain_clicked();

    void on_btn_mananger_register_clicked();

    void on_btn_mananger_check_clicked();

    void on_btn_mananger_print_clicked();

    void on_btn_mananger_exit_clicked();

    void on_btn_pay_exit_clicked();

    void on_btn_find_exit_clicked();

    void on_btn_sign_exit_clicked();

    void on_btn_sign_sign_clicked();

    void on_TimeOut();

    void on_btn_find_check_clicked();

    void on_btn_find_next_clicked();

    void on_btn_find_up_clicked();
	
    void on_btn_mananger_print_shift_clicked();

    void on_btn_wait_quit_clicked();
	
    void on_btn_pay_exitint_clicked();

private:
    void ShowWidget(QWidget *showwidget);

    void InitWidget();

    void ShowPayWidget();

private:
    Ui::HostWidget *ui;

    QList<QWidget *> _widgetlist;

    QWidget *_curr_show_widget;

    AlipayRequest _data;
    QJsonObject _posReqJsonObj;

    LabelsTimer *_label_pay_timer;

    LabelsTimer *_label_find_timer;

    LabelsTimer *_label_wait_timer;
	
    QTimer _intertime;

    QMovie *_label_pay_movie;

    int _line;

    bool _need_exit;

    bool _runing;

    POSType _posType;
    ReqType _type;
};

#endif // HOSTWIDGET_H
