#ifndef REQFACTORY_H
#define REQFACTORY_H

#include "requestmodel.h"
#include "global.h"
#include "fmtool.h"
#include "jsonfactory.h"

#include <QFile>
#include <QJsonDocument>
#include <QJsonParseError>
#include <QJsonObject>
#include <QApplication>

class ReqFactory
{
public:
    static bool GetReqJsonObj(const char* indata, QJsonObject &reqJsonObj)
    {
        QJsonParseError parseError;
        QJsonDocument inDataDoc = QJsonDocument::fromJson(QString(indata).toUtf8(), &parseError);
        if(parseError.error == QJsonParseError::NoError) {
            reqJsonObj = inDataDoc.object();
        } else {
            AlipayRequest request;
            memcpy(&request, indata, sizeof(struct AlipayRequest));
            ReqType type = (ReqType)(FMTool::GetString(request.TransType, 2).toInt());
            JsonFactory::GetJsonWithType(type, reqJsonObj, _request);
        }
    }

//private:
//    static void GetSPCCJson()
};

#endif // REQFACTORY_H
