﻿#ifndef CONTROL_H
#define CONTROL_H

#include "requestmodel.h"
#include "hostwidget.h"
//#include "DataProcess/fmp_database.h"
#include "fmp_settings.h"
#include <QObject>
#include <QApplication>
#include <QLibrary>
#include <QMutex>

class Control : public QObject
{
    Q_OBJECT

public:

    explicit Control(QObject *parent = 0);

    ~Control();

    void Start(const char *indata, char *outdata);

    void setIsinterrupt(bool isinterrupt);

#ifdef FM_TEST
    friend class TestSimphony;
#endif

signals:
    void Exits();

private:

    void GetResponse(QString errormessage, AlipayResponse &response);

    void GetErrorResponse(QString errormessage, AlipayResponse &response);

    void InitModel();

    bool SendMessageToServer(const QJsonObject &json, QByteArray &outdata, QString &error);

    bool SendMessageToPayMent(const QJsonObject &json, QByteArray &outdata, QString &error);

    bool SendMessageToSBKAPI(const QJsonObject &json, QByteArray &outdata, QString &error, int timeout, bool isReversal=false);

    void SetResPonseWithMessage(QString code, const QString &message);

    void RequestSign();

    bool GetRSA(QString &error);

    void Request(ReqType type, QStringList list);

    bool GetJson(QByteArray &json, QString &error);

    bool GetJson(ReqType type, QJsonObject &json, const QByteArray array, QString &error);

    bool HttpPost(QString url, QByteArray &outdata, const QByteArray &indata, QString content, QString accept, QString &error, int timeout);

    bool RollHttpPost(QString url, QByteArray &outdata, const QByteArray &indata, QString content, QString accept, QString &error, int timeout);

    void InitPOSReqJsonObj(const char *indata);

public slots:

    void RequestWithType(ReqType type, QStringList list);

    void OnInterrupt();

private:
    struct AlipayRequest _request;
    struct AlipayResponse _response;

    QJsonObject _posReqJsonObj;
    QJsonObject _responseJsonObj;
    HostWidget *_widget;
    //确保exe结束后不会重新弹窗
    QMutex _lock;

    QString _fmId;

    bool _isinterrupt;

    //FMPDataBase *_db;
    FMPSettings _setting;

    POSType _posType;
};

#endif // CONTROL_H
