#ifndef TOOLS
#define TOOLS

#include <winsock2.h>
#include <iphlpapi.h>
#include <Windows.h>

#include <string>
#include <QString>

EXTERN_C IMAGE_DOS_HEADER __ImageBase;

class ToolS
{
public:
    static void GetPath(QString &path)
    {
        char tmppath[MAX_PATH] = {0};
        GetProcPath(tmppath);
        path = QString(tmppath);
    }

    static void GetProcPath(char * pathBuf)
    {
        int curPos;

        GetModuleFileNameA((HMODULE)&__ImageBase, pathBuf, MAX_PATH);

        curPos = strlen(pathBuf) - 1;

        while('\\' != pathBuf[curPos])
        {
            curPos--;
        }

        curPos++;

        pathBuf[curPos] = '\0';
    }

    static int GetMacByGetAdaptersAddresses(std::string& macOUT)
    {
        bool ret = 0;

        ULONG outBufLen = sizeof(IP_ADAPTER_ADDRESSES);
        PIP_ADAPTER_ADDRESSES pAddresses = (IP_ADAPTER_ADDRESSES*)malloc(outBufLen);
        if (pAddresses == NULL)
            return 0;
        // Make an initial call to GetAdaptersAddresses to get the necessary size into the ulOutBufLen variable
        if(GetAdaptersAddresses(AF_UNSPEC, 0, NULL, pAddresses, &outBufLen) == ERROR_BUFFER_OVERFLOW)
        {
            free(pAddresses);
            pAddresses = (IP_ADAPTER_ADDRESSES*)malloc(outBufLen);
            if (pAddresses == NULL)
                return 0;
        }

        if(GetAdaptersAddresses(AF_UNSPEC, 0, NULL, pAddresses, &outBufLen) == NO_ERROR)
        {
            for(PIP_ADAPTER_ADDRESSES pCurrAddresses = pAddresses; pCurrAddresses != NULL; pCurrAddresses = pCurrAddresses->Next)
            {
                if(pCurrAddresses->PhysicalAddressLength != 6)
                    continue;
                char acMAC[32];
                sprintf(acMAC, "%02X-%02X-%02X-%02X-%02X-%02X",
                    int (pCurrAddresses->PhysicalAddress[0]),
                    int (pCurrAddresses->PhysicalAddress[1]),
                    int (pCurrAddresses->PhysicalAddress[2]),
                    int (pCurrAddresses->PhysicalAddress[3]),
                    int (pCurrAddresses->PhysicalAddress[4]),
                    int (pCurrAddresses->PhysicalAddress[5]));
                macOUT = acMAC;
                ret = 1;
                break;
            }
        }

        free(pAddresses);
        return ret;
    }

};

#endif // TOOLS

