﻿#ifndef REQUESTMODEL
#define REQUESTMODEL

typedef enum
{
    pay = 0,
    refund,
    endday,
    againprint,
    finds,
    sign
} ReqType;

struct EFTItem
{
    char billType[1]; //资金归属.   1:商户实收, 2:商户优惠
    char billId[8]; //支付类型.                //36464:用户支付,  36465: 微信优惠,  36466: 商家优惠
    char amount[12]; //金额
    char Reserved4[64]; //保留字段
    char Reserved5[8]; //保留字段
    char transactionNum[64]; //账单编号(非码交易序号)
};

struct AlipayResponse
{
    char ResponseCode[3]; //返回码
    char ResponseMsg[40]; //返回文字信息
    char Amount[12]; //订单金额（与wxpayRequest.Amount一致）
    char SettleNum[6]; //
    char MerchantID[15]; //商户id
    char TerminalID[8]; //
    char TransDate[8]; //交易日期
    char TransTime [6]; //交易时间
    char CardTraceNo[64];  //订单号(非码交易号)
    char NeedPrint[2]; //是否打印小票.  00:表示打印小票, 01:表示不打印小票
    char EFTprintFileName[200]; //打印文件路径.
    char MD5_CHECK_CODE [32]; //
    char Reserved1[48]; //保留
    char Reserved2[48];
    char Reserved3[48];
    char Reserved4[48];
    char Reserved5[48];
    char EFT_quantity[2]; //交易流水数量[1‐10]
    char EFT_Detail_information[10][157]; //交易流水列表。每条定义见struct EFTItem
};

struct product{
    char productID[8]; //商品id
    char buyCount[4]; //购买数量
    char unitPrice[8]; //单件商品价格
    char originPrice[8];//单件商品原价
    char isCombo[1]; //默认为0
    char isNonsale[1]; //(废弃)
    char productName[20]; //商品名字
};

struct AlipayRequest
{
    char PlatNo[4];  // *商户编号
    char TransType[2]; // 交易类型
    char PayType[2]; // 支付类型.
    char StoreNo[20]; // 门店号.
    char BusinessDay[8]; // 营业日期. ex:"20140307"
    char TransTime [6];  //交易时间 时分秒(HHMMss)
    char DeviceNo[6]; // *pos编号
    char CashierNo[6]; // 收银员编号。 ex:"001"
    char Amount[12]; // 需支付的金额（分）. ex:"1000"
    char Ticket_Amount[12];     //整单总金额（分）. ex:"2000"
    char non_sale_Amount[12]; //非卖品总金额(分)
    char CashTraceNo[6]; // 流水号. ex:"080001"
    char OriginTrace[64]; // 退款订单号（退款时使用）
    char Reserved1[48]; // 保留字段。
    char Reserved2[48]; // ""
    char Reserved3[48]; // ""
    char Reserved4[48]; // ""
    char Reserved5[48]; // ""
    char item_line_qty[2];      // item_information的数量[0‐99]
    char item_information [99][50];// 商品列表.最多99条商品，每条商品的格式由struct product定义
};

#endif // REQUESTMODEL

