﻿#ifndef JSONFACTORY
#define JSONFACTORY

#include "requestmodel.h"
#include "global.h"
#include "fmtool.h"
#include <QJsonObject>
#include <QJsonArray>
#include <QStringList>
#include <QJsonParseError>
#include <QJsonDocument>
#include <QDateTime>

//接受pos的请求转化为json
class JsonFactory
{
public:
    static bool GetJsonWithType(ReqType type, QJsonObject &json, const AlipayRequest &request, QStringList list = QStringList())
    {
        if(type == pay)
            return GetPayJson(json, request, list);
        if(type == refund)
            return GetRefundJosn(json, request, list);
        if(type == endday)
            return GetDayEndJson(json, request, list);
        if(type == againprint)
            return GetAgainPrinteJson(json, request, list);
        if(type == finds)
            return GetFindJson(json, request, list);
        return false;
    }

//    static bool GetResponseWithType(ReqType type, const QByteArray &rspJsonData, AlipayResponse &response)
//    {
//        QJsonParseError parseError;
//        QJsonDocument doc = QJsonDocument::fromJson(rspJsonData, &parseError);
//        if(parseError.error != QJsonParseError::NoError) {
//            return false;
//        }

//        QJsonObject rspJsonObj = doc.object();

//        if(type == pay)
//            return GetPayResponse(rspJsonObj, response);
//        if(type == refund)
//            return GetRefundResponse(rspJsonObj, response);
//        if(type == endday)
//            return GetDayEndResponse(rspJsonObj, response);
//        if(type == againprint)
//            return GetAgainPrinteResponse(rspJsonObj, response);
//        if(type == finds)
//            return GetFindResponse(rspJsonObj, response);
//        return false;
//    }

private:
    //支付
    static bool GetPayJson(QJsonObject &json, const AlipayRequest &request, QStringList list)
    {
        if(list.size() != 1 || list[0].isEmpty())
            return false;

        json.insert(JSON_KEY_VER, DEFAULT_JSON_VER_VALUE);
        json.insert(JSON_KEY_REQTYPE, JSON_REQTYPE_PAY);
        json.insert(JSON_KEY_PARTNERID, FMTool::GetString((const void *)&(request.PlatNo), 4).toInt());
        json.insert(JSON_KEY_STOREID, FMTool::GetString((const void *)&(request.StoreNo), 20));
        json.insert(JSON_KEY_STATIONID, FMTool::GetString((const void *)&(request.DeviceNo), 6));
        json.insert(JSON_KEY_OPERATORID, FMTool::GetString((const void *)&(request.CashierNo), 6));
        json.insert(JSON_KEY_TRANSID, FMTool::GetString((const void *)&(request.CashTraceNo), 6));
        json.insert(JSON_KEY_BUSINESSDATE, FMTool::GetString((const void *)&(request.BusinessDay), 8));
        json.insert(JSON_KEY_CODE, list[0]);
        json.insert(JSON_KEY_TRANSAMOUNT,  FMTool::GetString((const void *)&(request.Amount), 12).toInt());
        json.insert(JSON_KEY_UNAMOUNT,  FMTool::GetString((const void *)&(request.non_sale_Amount), 12).toInt());
        json.insert(JSON_KEY_PARTORDERID, FMTool::GetString((const void *)&(request.Reserved1), 64));

        int len = FMTool::GetString((const void *)&(request.item_line_qty), 2).toInt();
        QJsonArray prod;


        qDebug() << "--------" << len;

        for(int i = 0; i < len; ++i)
        {
            QJsonObject object;

            struct product *pro = (struct product *)request.item_information[i];

            object.insert(JSON_KEY_PRODUCTS_CONSUMENUM, FMTool::GetString((const void *)&(pro->buyCount), 4));
            object.insert(JSON_KEY_PRODUCTS_PID, FMTool::GetString((const void *)&(pro->productID), 8));
            object.insert(JSON_KEY_PRODUCTS_NAME, FMTool::GetString((const void *)&(pro->productName), 20));
            object.insert(JSON_KEY_PRODUCTS_SALESTYPE, DEFAULT_JSON_PRODUCTS_NORMAL);

            QString typebuf = FMTool::GetString((const void *)&(pro->isCombo), 1);

            if(typebuf == 0)
                object.insert(JSON_KEY_PRODUCTS_SALESTYPE, DEFAULT_JSON_PRODUCTS_FREE);

            object.insert(JSON_KEY_PRODUCTS_PRICE, FMTool::GetString((const void *)&(pro->unitPrice), 8));
            prod.append(object);

        }

        json.insert(JSON_KEY_PRODUCTS, prod);

        return true;

    }
    //退款
    static bool GetRefundJosn(QJsonObject &json, const AlipayRequest &request, QStringList list)
    {
        if(list.size() != 1 || list[0].isEmpty())
            return false;

        json.insert(JSON_KEY_VER, DEFAULT_JSON_VER_VALUE);
        json.insert(JSON_KEY_REQTYPE, JSON_REQTYPE_REFUND);
        json.insert(JSON_KEY_PARTNERID, FMTool::GetString((const void *)&(request.PlatNo), 4).toInt());
        json.insert(JSON_KEY_STOREID, FMTool::GetString((const void *)&(request.StoreNo), 20));
        json.insert(JSON_KEY_STATIONID, FMTool::GetString((const void *)&(request.DeviceNo), 6));
        json.insert(JSON_KEY_OPERATORID, FMTool::GetString((const void *)&(request.CashierNo), 6));
        json.insert(JSON_KEY_REFUNDID, FMTool::GetString((const void *)&(request.CashTraceNo), 6));
        json.insert(JSON_KEY_BUSINESSDATE, FMTool::GetString((const void *)&(request.BusinessDay), 8));
        json.insert(JSON_KEY_FMID, list[0]);
        json.insert(JSON_KEY_REFUNDAMOUT,  FMTool::GetString((const void *)&(request.Amount), 12).toInt());
        json.insert(JSON_KEY_PARTORDERID, FMTool::GetString((const void *)&(request.Reserved1), 64));

        return true;

    }
    //日结
    static bool GetDayEndJson(QJsonObject &json, const AlipayRequest &request, QStringList list)
    {
        json.insert(JSON_KEY_VER, DEFAULT_JSON_VER_VALUE);
        json.insert(JSON_KEY_REQTYPE, JSON_REQTYPE_ENDDAY);
        json.insert(JSON_KEY_PARTNERID, FMTool::GetString((const void *)&(request.PlatNo), 4).toInt());
        json.insert(JSON_KEY_STOREID, FMTool::GetString((const void *)&(request.StoreNo), 20));
        json.insert(JSON_KEY_STATIONID, FMTool::GetString((const void *)&(request.DeviceNo), 6));
        json.insert(JSON_KEY_ENDTIME, FMTool::GetString((const void *)&(request.BusinessDay), 8).append( FMTool::GetString((const void *)&(request.TransTime), 6)));
        json.insert(JSON_KEY_PARTORDERID, FMTool::GetString((const void *)&(request.Reserved1), 64));
        json.insert(JSON_KEY_PRINTACTION, QString("103"));

        return true;
    }
    //重打小票
    static bool GetAgainPrinteJson(QJsonObject &json, const AlipayRequest &request, QStringList list)
    {
        if(!list.isEmpty() && list[0].isEmpty())
            return false;
        json.insert(JSON_KEY_VER, DEFAULT_JSON_VER_VALUE);
        json.insert(JSON_KEY_REQTYPE, JSON_REQTYPE_PRINTER);
        json.insert(JSON_KEY_PARTNERID, FMTool::GetString((const void *)&(request.PlatNo), 4).toInt());
        json.insert(JSON_KEY_STOREID, FMTool::GetString((const void *)&(request.StoreNo), 20));
        json.insert(JSON_KEY_STATIONID, FMTool::GetString((const void *)&(request.DeviceNo), 6));
        json.insert(JSON_KEY_OPERATORID, FMTool::GetString((const void *)&(request.CashierNo), 6));
        json.insert(JSON_KEY_FMID, list[0]);
        json.insert(JSON_KEY_PRINTACTION, QString("103"));

        return true;
    }
    //查询流水
    static bool GetFindJson(QJsonObject &json, const AlipayRequest &request, QStringList list)
    {
        if(list.size() != 3 || list[0].isEmpty() || list[1].isEmpty())
            return false;

        QString tmp0 = list[0];
        QString tmp1 = list[1];
        QString tmp2 = list[2];

        QString cur = QDateTime::currentDateTime().toString("hh:mm:ss");

        tmp0.append(" 00:00:00");
        tmp1.append(QString(" ") + cur);

        json.insert(JSON_KEY_VER, DEFAULT_JSON_VER_VALUE);
        json.insert(JSON_KEY_REQTYPE, JSON_REQTYPE_FIND);
        json.insert(JSON_KEY_PARTNERID, FMTool::GetString((const void *)&(request.PlatNo), 4).toInt());
        json.insert(JSON_KEY_STOREID, FMTool::GetString((const void *)&(request.StoreNo), 20));
        json.insert(JSON_KEY_STATIONID, FMTool::GetString((const void *)&(request.DeviceNo), 6));
        json.insert(JSON_KEY_OPERATORID, FMTool::GetString((const void *)&(request.CashierNo), 6));
        json.insert(JSON_KEY_BEGINTIME, tmp0);
        json.insert(JSON_KEY_ENDTIME, tmp1);
        json.insert(JSON_KEY_PAGESIZE, 10);
        json.insert(JSON_KEY_PAGENUM, tmp2.toInt());
        json.insert(JSON_KEY_METHCODE, 10001);

        return true;
    }

//    // 支付AlipayResponse
//    static bool GetPayResponse(const QJsonObject &rspJsonObj, AlipayResponse &response)
//    {
//        return false;
//    }
//    // 退款AlipayResponse
//    static bool GetRefundResponse(const QJsonObject &rspJsonObj, AlipayResponse &response)
//    {
//        return true;
//    }
//    // 日结AlipayResponse
//    static bool GetDayEndResponse(const QJsonObject &rspJsonObj, AlipayResponse &response)
//    {
//        return true;
//    }
//    // 重打小票AlipayResponse
//    static bool GetAgainPrinteResponse(const QJsonObject &rspJsonObj, AlipayResponse &response)
//    {
//        return true;
//    }
//    // 查询AlipayResponse
//    static bool GetFindResponse(const QJsonObject &rspJsonObj, AlipayResponse &response)
//    {
//        return true;
//    }

};

#endif // JSONFACTORY

