﻿#ifndef CONTROL_H
#define CONTROL_H

#include "requestmodel.h"
#include "hostwidget.h"
//#include "DataProcess/fmp_database.h"
#include <QObject>
#include <QApplication>
#include <QLibrary>
#include <QMutex>

class Control : public QObject
{
    Q_OBJECT

public:

    explicit Control(QObject *parent = 0);

    ~Control();

    void Start(const char *indata, char *outdata);

    //static void GetProcPath(char *pathBuf);
    void setIsinterrupt(bool isinterrupt);

signals:
    void Exits();

private:

    void GetResponse(QString errormessage, AlipayResponse &response);

    void GetErrorResponse(QString errormessage, AlipayResponse &response);

    void InitModel();

    bool SendMessageToPayMent(const QJsonObject &json, QByteArray &outdata, QString &error);

    void SetResPonseWithMessage(QString code, const QString &message);

    void RequestSign();

    bool GetRSA(QString &error);

    void Request(ReqType type, QStringList list);

    bool GetJson(QByteArray &json, QString &error);

    bool GetJson(ReqType type, QJsonObject &json, const QByteArray array, QString &error);

    bool HttpPost(QString url, QByteArray &outdata, const QByteArray &indata, QString content, QString accept, QString &error, int timeout, bool ispay = false);

    bool RollHttpPost(QString url, QByteArray &outdata, const QByteArray &indata, QString content, QString accept, QString &error, int timeout);

public slots:

    void RequestWithType(ReqType type, QStringList list);

private:
    struct AlipayRequest _request;
    struct AlipayResponse _response;
    HostWidget *_widget;
    //确保exe结束后不会重新弹窗
    QMutex _lock;

    QString _fmId;

    bool _isinterrupt;

    //FMPDataBase *_db;

};

#endif // CONTROL_H
