﻿#include "control.h"
#include "global.h"
#include "fmtool.h"
#include "fmerror.h"
#include "QsLog.h"
#include "jsonfactory.h"
#include "rspfactory.h"
#include <QSemaphore>
#include <QtConcurrent>
#include <QSettings>
#include <QJsonObject>
#include <QEventLoop>
#include <QFont>
#include <QFontDatabase>
#include <QApplication>
#include <QSqlError>
#include <QSqlQuery>
#include <QSslSocket>
#include <QSslConfiguration>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QJsonDocument>
#include <Windows.h>
#include "DataProcess/rollback.h"
#include "DataProcess/tools.h"
#include "DataProcess/cretopt.h"
#include "DataProcess/fmnetwork.h"

Control::Control(QObject *parent) : QObject(parent), _widget(NULL)
{
    QString path;
    ToolS::GetPath(path);
    QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE", QString("creat"));
    db.setDatabaseName(path + DB_ORDER);
    db.open();

    if(db.isOpen())
    {
        QSqlQuery query(db);

        QString sql = QString("create table ") + DB_TABLE_NAME + " ("
                              "orderid varchar(60) primary key, "
                              "content text"
                              ")";

        bool flag = query.exec(sql);

        if(!flag)
            QLOG_WARN() << query.lastError();

        db.close();

    }else
    {
        QLOG_ERROR()<< "----" <<db.open();
        QLOG_ERROR() << db.lastError().type() << db.lastError().text();
    }

    _isinterrupt = false;

    InitModel();
}

Control::~Control()
{
//    if(_db != NULL)
//    {
//       delete _db;
//       _db = NULL;
//    }
}

void Control::Start(const char *indata, char *outdata)
{
    bool refundflag = false;
    QLOG_INFO() << "get data from pos:" << indata;

    QString appPath;
    char pathStr[MAX_PATH] = { 0 };
    ToolS::GetProcPath(pathStr);
    appPath = QString::fromLocal8Bit(pathStr);
    appPath = appPath.replace("\\", "/");
    QFontDatabase::addApplicationFont(appPath + "msyh.ttf");
    QFont ft("Microsoft YaHei UI Light");
    qApp->setFont(ft);

    //QDir::setCurrent(appPath);
    QLOG_INFO() << "Openssl support:" << QSslSocket::supportsSsl();
    QLOG_INFO() << "Openssl support:" << QSslSocket::supportsSsl() << QApplication::libraryPaths();

    QEventLoop loop;
    if(_widget == NULL)
        _widget = new HostWidget();

    memcpy(&_request, indata, sizeof(struct AlipayRequest));

    connect(_widget, &HostWidget::Interrupt, this, [this](){
        _isinterrupt = true;
    });

    connect(_widget, &HostWidget::RequestWithType, this, &Control::RequestWithType);

    connect(_widget, &HostWidget::Exits, this, [&loop, &refundflag] ()
    {
        QLOG_INFO() << "quit with normal";
        refundflag = true;
        loop.exit();
    });
    connect(_widget, &HostWidget::ExitWithMSG, this, [this, &loop] (QString code, QString message)
    {
        QLOG_INFO() << "quit with : " << message;
        SetResPonseWithMessage(code, message);
        loop.exit();
    });

    QString reqtype;

    reqtype.append(_request.TransType[0]).append(_request.TransType[1]);

    _widget->ShowWithRequest(_request);


    if(reqtype.compare("40") != 0)
    {
        loop.exec();
    }else
    {
        if(reqtype.compare("40") == 0 && refundflag == false)
            loop.exec();
    }

    _lock.lock();
    delete _widget;
    _widget = NULL;
    _lock.unlock();

    memcpy(outdata, (char *)(&_response), sizeof(struct AlipayResponse));
    outdata[sizeof(struct AlipayResponse)] = 0;

    QLOG_INFO() << "return data to pos : " << outdata;
    qDebug() << "****************** currpath *******************88" << QDir::currentPath();
}

void Control::SetResPonseWithMessage(QString code, const QString &message)
{
    FMTool::SetString(_response.ResponseCode, 3, code);
    FMTool::SetString(_response.ResponseMsg, 40, message);
}

void Control::InitModel()
{
    memset(&_request, ' ', sizeof(struct AlipayRequest));
    memset(&_response, ' ', sizeof(struct AlipayResponse));
}

bool Control::SendMessageToPayMent(const QJsonObject &json, QByteArray &outdata, QString &error)
{
    QByteArray array;
    QString path;
    ToolS::GetPath(path);

    QString iv = json[JSON_KEY_PARTNERID].toString() + json[JSON_KEY_STOREID].toString() + json[JSON_KEY_STATIONID].toString();

    QString url = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_URL).toString();

    QJsonObject tmpjson = json;
    CretOperate::GetMAC(tmpjson);
    CretOperate::GetSign(tmpjson, iv);
    bool ispay = false;


    QLOG_INFO() << "send json to payment: " << tmpjson;

    if(tmpjson.contains(JSON_KEY_REQTYPE) && tmpjson[JSON_KEY_REQTYPE].toInt() == 72)
        ispay = true;

    if(tmpjson.contains(JSON_KEY_REQTYPE) && tmpjson[JSON_KEY_REQTYPE].toInt() == 62)
        ispay = true;

    QByteArray data = QJsonDocument(tmpjson).toJson(QJsonDocument::Compact);

    if(!Control::HttpPost(url, array, data, "application/json;charset=utf-8", "application/json", error, 60, ispay))
    {   
        if(!_isinterrupt)
        {
            //如果没有点击取消支付按钮直接写数据库异步冲正
            if(json.contains(JSON_KEY_REQTYPE) && json[JSON_KEY_REQTYPE].toInt() == 72)
            {
//                QVariantHash hash;

//                hash.insert(SQL_KEY_ORDERID, json[JSON_KEY_PARTORDERID].toString());
//                hash.insert(SQL_KET_CONTENT, QString(data));

//                _db->insert(DB_TABLE_NAME, hash);

                RollBack::SetRollOrder(json[JSON_KEY_PARTORDERID].toString(), QString(data));
            }
        }

        return false;
    }

    outdata = array;

    return true;
}

bool Control::HttpPost(QString url, QByteArray &outdata, const QByteArray &indata, QString content, QString accept, QString  &error, int timeout, bool ispay)
{
    QString path;
    ToolS::GetPath(path);

    QString host = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_HOST).toString();

    QEventLoop loop;
    QTimer timer;

    QSslConfiguration config = QSslConfiguration::defaultConfiguration();
    config.setPeerVerifyMode(QSslSocket::VerifyNone);

    QNetworkAccessManager manger;
    QNetworkRequest request(url);

    request.setSslConfiguration(config);

    request.setRawHeader("Content-Type", content.toUtf8());
    request.setRawHeader("Accept", accept.toUtf8());
    request.setRawHeader("Host", host.toUtf8());
    request.setRawHeader("Authorization", "Basic dXBzLWNsaWVudDo2VGk4TjBXNzRyb1A=");


    QNetworkReply* reply = manger.post(request, indata);

    connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
    connect(&manger, &QNetworkAccessManager::finished, &loop, &QEventLoop::quit);
    connect(_widget, &HostWidget::Interrupt, &loop, &QEventLoop::quit);
    connect(reply, static_cast<void (QNetworkReply::*)(QNetworkReply::NetworkError)>(&QNetworkReply::error), &loop, &QEventLoop::quit);
    timer.start(timeout*1000);

    loop.exec();

    reply->deleteLater();


    if(_isinterrupt)
    {
        error = QString::fromLocal8Bit("收款被取消");
        return false;
    }


    if(reply->error() != QNetworkReply::NoError)
    {
        if(ispay)
            error = QString::fromLocal8Bit("网路异常.交易失败.如已扣款将会自动返还");
        else
            error = QString::fromLocal8Bit("网络异常,请检查网络后重试");

        QLOG_INFO() << reply->errorString() << "Contents: " << reply->readAll();
        return false;
    }

    outdata = reply->readAll();

    if(outdata.isEmpty())
    {
        if(ispay)
            error = QString::fromLocal8Bit("网路异常.交易失败.如已扣款将会自动返还");
        else
            error = QString::fromLocal8Bit("网络异常,请检查网络后重试");
        QLOG_INFO() << reply->errorString() << "Contents: " << reply->readAll();
        return false;
    }

    QLOG_INFO() << outdata.data();

    return true;
}

bool Control::RollHttpPost(QString url, QByteArray &outdata, const QByteArray &indata, QString content, QString accept, QString &error, int timeout)
{
    QString path;
    ToolS::GetPath(path);

    QString host = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_HOST).toString();

    QEventLoop loop;
    QTimer timer;

    QSslConfiguration config = QSslConfiguration::defaultConfiguration();
    config.setPeerVerifyMode(QSslSocket::VerifyNone);

    QNetworkAccessManager manger;
    QNetworkRequest request(url);

    request.setSslConfiguration(config);

    request.setRawHeader("Content-Type", content.toUtf8());
    request.setRawHeader("Accept", accept.toUtf8());
    request.setRawHeader("Host", host.toUtf8());
    request.setRawHeader("Authorization", "Basic dXBzLWNsaWVudDo2VGk4TjBXNzRyb1A=");


    QNetworkReply* reply = manger.post(request, indata);

    connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
    connect(&manger, &QNetworkAccessManager::finished, &loop, &QEventLoop::quit);
    connect(_widget, &HostWidget::Interrupt, &loop, &QEventLoop::quit);
    connect(reply, static_cast<void (QNetworkReply::*)(QNetworkReply::NetworkError)>(&QNetworkReply::error), &loop, &QEventLoop::quit);
    timer.start(timeout*1000);

    loop.exec();

    reply->deleteLater();

    if(reply->error() != QNetworkReply::NoError)
    {
        error = QString::fromLocal8Bit("网络异常,获取服务端返回数据失败");
        QLOG_INFO() << reply->errorString() << "Contents: " << reply->readAll();
        return false;
    }

    outdata = reply->readAll();

    if(outdata.isEmpty())
    {
        error = QString::fromLocal8Bit("网络异常,获取服务端返回数据为空");
        QLOG_INFO() << reply->errorString() << "Contents: " << reply->readAll();
        return false;
    }

    QLOG_INFO() << outdata.data();

    return true;
}

bool Control::GetRSA(QString &error)
{

    QJsonObject json;
    QString iv;

    json.insert(JSON_KEY_VER, DEFAULT_JSON_VER_VALUE);
    json.insert(JSON_KEY_REQTYPE, 99);
    json.insert(JSON_KEY_STOREID, FMTool::GetString(_request.StoreNo, 20));
    json.insert(JSON_KEY_STATIONID, FMTool::GetString(_request.DeviceNo, 6));
    json.insert(JSON_KEY_PARTNERID, FMTool::GetString(_request.PlatNo, 4));

    iv = FMTool::GetString(_request.PlatNo, 4) + FMTool::GetString(_request.StoreNo, 20) + FMTool::GetString(_request.DeviceNo, 6);

    QLOG_INFO() << "get iv : " << iv;

    CretOperate::GetDES3MAC(json, iv);
    QByteArray array;

    QLOG_INFO() << "get mac sign request : " << json;

    QString path;
    ToolS::GetPath(path);
    QString url = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_URL_CRET).toString();
    QByteArray data = QJsonDocument(json).toJson(QJsonDocument::Compact);

    if(!Control::HttpPost(url, array, data,"application/json;charset=utf-8", "application/json", error, 60))
    {
        QLOG_ERROR() << "httppos error :" << error;
        return false;
    }

    if(CretOperate::SetRSACret(array, iv) == 0)
    {
        error = QString::fromLocal8Bit("签名失败，请重新获取签名");
        return false;
    }

    return true;
}

void Control::RequestSign()
{
    QString error;
    bool rlt = GetRSA(error);

    if(rlt)
        SetResPonseWithMessage("100", QString::fromLocal8Bit("签名成功"));
    else
        SetResPonseWithMessage("22", QString::fromLocal8Bit("签名失败"));

    _lock.lock();
    if(_widget != NULL)
        _widget->ShowWiteMGS(sign, rlt, error);
    _lock.unlock();
}

bool Control::GetJson(ReqType type,QJsonObject &json, const QByteArray array, QString &error)
{
    QJsonDocument jsonDocument = QJsonDocument::fromJson(array.data());

    if( jsonDocument.isNull() )
    {
        QLOG_ERROR() << "server return not json";
        error = QString::fromLocal8Bit("服务端返回数据异常");
        return false;
    }

    json = jsonDocument.object();

    if(json.contains(JSON_KEY_MESSAGE) && json.contains(JSON_KEY_STATUSCODE) && (json[JSON_KEY_STATUSCODE].toInt() == 307 || json[JSON_KEY_STATUSCODE].toInt() == 303))
    {
        error = QString::fromLocal8Bit("签名过期，请重新获取签名");
        json.insert(JSON_KEY_MESSAGE, QString::fromLocal8Bit("签名过期，请重新获取签名"));
    }

    if(type == againprint)
        json.insert(JSON_KEY_FMID, _fmId);

    if(type == refund && json.contains(JSON_KEY_STATUSCODE) && json[JSON_KEY_STATUSCODE].toInt() == 100)
        json.insert(JSON_KET_CLIENTREF, FMTool::GetString(_request.Amount, 12));

    RspFactory::GetResPonseJson(type, _response, json);

    if(json.contains(JSON_KEY_MESSAGE))
        error = json[JSON_KEY_MESSAGE].toString();

    if(json.contains(JSON_KEY_STATUSCODE) && json[JSON_KEY_STATUSCODE].toInt() == 100)
        return true;

    return false;
}

void Control::Request(ReqType type, QStringList list)
{
    QJsonObject json, rtjson;
    QString error;
    QByteArray outdata;

    JsonFactory::GetJsonWithType(type, json, _request, list);

    if(type == againprint)
        _fmId = list[0];

    bool rlt = SendMessageToPayMent(json, outdata, error);

    if(rlt)
        rlt = Control::GetJson(type, rtjson, outdata, error);
    else
        SetResPonseWithMessage("23", error);

    if(!_isinterrupt)
    {
        _lock.lock();
        if(_widget != NULL && type == finds)
        {
            _widget->ShowWiteJson(rlt, rtjson, error);
        }
        else
        {
            _widget->ShowWiteMGS(type, rlt, error);
        }
        _lock.unlock();
    }
    else
    {
        int i = 0;
        bool tmpflag = false;

        QByteArray tmparray;
        QString path, tmperror;
        ToolS::GetPath(path);
        QString url = QSettings(path + "\\" + USERCONFIG_NAME, QSettings::IniFormat).value(VALUE_URL).toString();

        QString iv = json[JSON_KEY_PARTNERID].toString() + json[JSON_KEY_STOREID].toString() + json[JSON_KEY_STATIONID].toString();

        QJsonObject tmpjson = json;
        tmpjson.insert(JSON_KEY_REQTYPE, 3);
        CretOperate::GetSign(tmpjson, iv);

        QLOG_INFO() << "send json to payment: " << tmpjson;

        QByteArray tmpdata = QJsonDocument(tmpjson).toJson(QJsonDocument::Compact);

        while(i < 3)
        {
            if((tmpflag = RollHttpPost(url, tmparray, tmpdata,"application/json;charset=utf-8", "application/json", tmperror, 15)) == true)
                break;
            QLOG_ERROR() << "rollback failed : " << tmperror;

            ++i;
        }
        if(tmpflag)
            SetResPonseWithMessage("23", QString::fromLocal8Bit("支付取消成功.如已扣款将会自动返还"));
        else
        {
//            QVariantHash hash;

//            hash.insert(SQL_KEY_ORDERID, json[JSON_KEY_PARTORDERID].toString());
//            hash.insert(SQL_KET_CONTENT, QString(tmpdata));

//            QLOG_ERROR() << "roll back faile , move request to database : " << json;

//            _db->insert(DB_TABLE_NAME, hash);

            RollBack::SetRollOrder(json[JSON_KEY_PARTORDERID].toString(), QString(tmpdata));

            SetResPonseWithMessage("23", QString::fromLocal8Bit("支付取消成功.如已扣款将会自动返还"));
        }

        _lock.lock();
        if(_widget != NULL && type == finds)
        {
            _widget->ShowWiteJson(rlt, rtjson, error);
        }
        else
        {
            _widget->ShowWiteMGS(type, rlt, error);
        }
        _lock.unlock();

    }
}

void Control::RequestWithType(ReqType type, QStringList list)
{
    if(type == sign)
    {
        RequestSign();
        return ;
    }
    Request(type, list);
}

void Control::setIsinterrupt(bool isinterrupt)
{
    _isinterrupt = isinterrupt;
}
