#ifndef FMP_SETTINGS_H
#define FMP_SETTINGS_H

#include <QObject>
class FMPSettingsPrivate;

/**
 * @brief The FMPSettings class
 */
class FMPSettings : public QObject
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(FMPSettings)

public:
    explicit            FMPSettings(QObject *parent = nullptr);
    virtual             ~FMPSettings();

public:
    QVariant            GetValue(const QString &k, QVariant default_val);
    bool                SetValue(const QString&k, QVariant v);

private:
    FMPSettingsPrivate *d_ptr;
};


class QSettings;
/**
 * @brief The FMPSettingsPrivate class
 */
class FMPSettingsPrivate:public QObject
{
    Q_OBJECT
    Q_DECLARE_PUBLIC(FMPSettings)
public:
    explicit            FMPSettingsPrivate(QObject *parent = nullptr);

    QVariant            GetValue(const QString &k, QVariant default_val);
    bool                SetValue(const QString&k, QVariant v);

public:
    FMPSettings        *q_ptr;
    QSettings          *_sets;
};

#endif // FMP_SETTINGS_H
