#ifndef FMNETWORK_H
#define FMNETWORK_H

#include <QObject>
#include <QByteArray>
#include "global.h"
#include "requestmodel.h"

class FMNetWork : public QObject
{
    Q_OBJECT
public:
    explicit FMNetWork(QObject *parent = 0);

    static bool HttpPost(QString url, QByteArray &outdata, const QByteArray &indata, QString content, QString accept, QString &error = QString(), int timeout = 60);

    static QByteArray CreateOLTPXML(const QJsonObject &json);

    static bool RequestToOLTP(const QJsonObject &json, QByteArray &outdata, QString &error, int timeout);
};

#endif // FMNETWORK_H
