#ifndef FMVIPREFUND_H
#define FMVIPREFUND_H

#include "fmvipwnd.h"


namespace Ui {
class FMVipRefund;
}

namespace FMItem {
class Order;
class Pay;
}

class FMVipRefund : public FMVipWnd
{
    Q_OBJECT

public:
    explicit FMVipRefund(QDialog *parent = 0);
    ~FMVipRefund();

    bool    initWnd(Session *session);

    void refresh();

    bool isRefundSuccess() const;
    void setIsRefundSuccess(bool isRefundSuccess);

signals:
    void refundPay(int);
    void refundOrder(int);

private slots:
    void onBtnRefundClicked();

    void on_btn_refund_order_clicked();

    void on_close_btn_clicked();

private:
    Ui::FMVipRefund *ui;

    FMItem::Order *order;
    QList<QSharedPointer<FMItem::Pay> > pays;

    bool _isRefundSuccess;
};

#endif // FMVIPREFUND_H
