﻿#include "fmviprefund.h"
#include "ui_fmviprefund.h"
#include "fmvippanel.h"
#include <QFile>
#include <QMutex>
#include "fmloading.h"
#include "fmmsgwnd.h"
#include "dbop.h"
#include "items/order.h"
#include "items/pay.h"
#include "items/storeinfo.h"

FMVipRefund::FMVipRefund(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipRefund),
    order(new FMItem::Order(this)) ,
    _isRefundSuccess(false)
{
    ui->setupUi(this);
}

FMVipRefund::~FMVipRefund()
{
    delete ui;
    delete order;
    pays.clear();
}

bool FMVipRefund::initWnd(Session *session)
{
    this->_session = session;

    ui->store_label->setText(session->data(PosProps.StoreId).toString());
    ui->pos_label->setText(session->data(PosProps.PosId).toString());
    ui->operator_label->setText(session->data(PosProps.OperatorId).toString());
    ui->bd_label->setText(session->data(PosProps.BussinessDate).toString());

    QString orderId = session->data(PosProps.OrderId).toString();
    DBOP::GetOrderByOrderId(orderId, order);

    FMItem::StoreInfo storeInfo;
    DBOP::GetItemByDBID(order->storeInfoDBID(), &storeInfo);

    if(order->isNew()) {
        ui->textEdit_order->setText(QString::fromLocal8Bit("未找到orderId为 %1 的订单! ").arg(orderId));
    } else {
        QString orderInfo = QString::fromLocal8Bit("POS订单号：%1\n"
                                                   "非码订单号：%2\n"
                                                   "订单总额：%3 \t 已付金额：%4\n"
                                                   "营业日：%5 \t 收银员：%6\n"
                                                   "门店号：%7 \t POS号：%8\n")
                .arg(order->orderId()).arg(order->fmOrderId())
                .arg(order->orderAmount()/100.0).arg(order->paidAmount()/100.0)
                .arg(storeInfo.businessDate()).arg(storeInfo.operatorId())
                .arg(storeInfo.storeId()).arg(storeInfo.posId());
        if(order->refunded()) {
            orderInfo += QString::fromLocal8Bit("订单已退款\n");
            ui->btn_refund_order->setEnabled(false);
        } else if (order->settled()) {
            orderInfo += QString::fromLocal8Bit("订单已结算，可以退整单\n");
            ui->btn_refund_order->setEnabled(true);
        } else {
            orderInfo += QString::fromLocal8Bit("订单还未结算，可以选择退某笔支付\n");
            ui->btn_refund_order->setEnabled(false);
        }
        ui->textEdit_order->setText(orderInfo);

        pays = DBOP::GetPaysByOrderDBId(order->DBID());

        int row = 0, col = 0;
        foreach (auto payPointer, pays) {
            if(row == 0) {
                QStringList headerLabels;
                headerLabels << QString::fromLocal8Bit("支付方式") << QString::fromLocal8Bit("支付金额") << QString::fromLocal8Bit("已退金额") << QString::fromLocal8Bit("操作");
                ui->tableWidget_pays->setRowCount(pays.length());
                ui->tableWidget_pays->setColumnCount(headerLabels.length());
                ui->tableWidget_pays->setHorizontalHeaderLabels(headerLabels);
                int tableWidth = ui->tableWidget_pays->width();
                ui->tableWidget_pays->setColumnWidth(0, tableWidth*0.4);
                ui->tableWidget_pays->setColumnWidth(1, tableWidth*0.2);
                ui->tableWidget_pays->setColumnWidth(2, tableWidth*0.2);
                ui->tableWidget_pays->setColumnWidth(3, tableWidth*0.17);
            }

            QStringList payInfo;
            payInfo << payPointer->payStr() << QString::number(payPointer->payAmount() / 100.0) << QString::number(payPointer->refundAmount() / 100.0);
            foreach (const QString payInfoItem, payInfo) {
                ui->tableWidget_pays->setItem(row, col, new QTableWidgetItem(payInfoItem));
                col ++;
            }
            if(payPointer->payAmount() > 0) {
                auto btn = new QPushButton(QString::fromLocal8Bit("退款"), ui->tableWidget_pays);
                btn->setProperty("DBID", payPointer->DBID());
                connect(btn, &QPushButton::clicked, this, &FMVipRefund::onBtnRefundClicked);
                ui->tableWidget_pays->setCellWidget(row, col, btn);
                btn->setCursor(QCursor(Qt::PointingHandCursor));

                if((payPointer->payAmount() <= payPointer->refundAmount()) || order->settled() || order->refunded()
                        || payPointer->payId()!="20001") {
                    btn->setEnabled(false);
                }
            }

            row++;
            col = 0;
        }
    }

    return true;
}

void FMVipRefund::onBtnRefundClicked()
{
    auto btn = qobject_cast<QPushButton*>(sender());

    int DBID = btn->property("DBID").toInt();

    emit refundPay(DBID);
}

void FMVipRefund::refresh()
{
    initWnd(this->session());
}

void FMVipRefund::on_btn_refund_order_clicked()
{
    emit refundOrder(order->DBID());
}

void FMVipRefund::on_close_btn_clicked()
{
    if(_isRefundSuccess) {
        this->accept();
    } else {
        this->reject();
    }
}

bool FMVipRefund::isRefundSuccess() const
{
    return _isRefundSuccess;
}

void FMVipRefund::setIsRefundSuccess(bool isRefundSuccess)
{
    _isRefundSuccess = isRefundSuccess;
}
