﻿#ifndef FMVIPORDER_H
#define FMVIPORDER_H
#include <QListWidgetItem>
#include <QModelIndex>
#include <QLabel>
#include <QVBoxLayout>
#include "fmvipwnd.h"
#include "global.h"


class CouponModel;
class QItemSelectionModel;
class FMNumPad;

#define MIN(a,b) ((a<b) ? a : b)
#define MAX(a,b) ((a<b) ? b : a)
#define DOUBLE_STR(num) QString::number(num, 'f', 2)

namespace Ui {
class FMVipOrder;
}

class FMVipOrder : public FMVipWnd
{
    Q_OBJECT

public:
    explicit FMVipOrder(QDialog *parent = 0);
    ~FMVipOrder();

    bool initWnd(Session *session);
    void initCouponItems();
    void setWillPayText();

signals:
    void    pay();

#ifdef FASTPAY
    void    couponReq(const QString &code);
#endif

public slots:
    void    on_pay_btn_clicked();

private slots:
    void on_coupon_prev_btn_clicked();

    void on_coupon_next_btn_clicked();

    void on_pay_edit_textChanged(const QString &text);

    void onSelectionChanged(const QItemSelection &selected, const QItemSelection &deselected);
    void on_coupon_page_clicked(const QModelIndex &index);

    void on_score_edit_textChanged(const QString &scoreStr);

    void on_pay_key_clicked();

#ifdef FASTPAY

    void on_scanfLe_returnPressed();

    void setRealPay();

#endif

private:
    class OrderInfo
    {
    public:
        OrderInfo()
        {
            _amountStr = _needPayStr = "";
            _amount = _score = _payScore = _needPay = _maxWillPay = _payAmountScore = _payAmountCoupon = 0;
        }
        OrderInfo(QString amountStr, int score, QString needPayStr)
        {
            this->_amountStr = amountStr;
            this->_needPayStr = needPayStr;

            _amount = _amountStr.toInt() / 100.0;
            _needPay = _needPayStr.toInt() / 100.0;
            _score = score;

            _payScore = _maxWillPay = _payAmountScore = _payAmountCoupon = 0;
            setMaxWillPay();
        }

        QString getAmountStr()
        {
            return DOUBLE_STR(_amount);
        }

        QString getNeedPayStr()
        {
            return DOUBLE_STR(_needPay);
        }

        /**
         * @brief getPayAmountScore
         * 设置/获取积分抵扣金额
         * @return
         */
        void setUseScore(int payScore)
        {
            _payScore = payScore;
            if(payScore < 1000) {
                _payAmountScore = payScore/100.0 * 0;
            } else if(payScore < 4999) {
                _payAmountScore = payScore/100.0 * 1.0;
            } else if(payScore < 9999) {
                _payAmountScore = payScore/100.0 * 1.2;
            } else {
                _payAmountScore = payScore/100.0 * 1.5;
            }
            setMaxWillPay();
        }
        double getPayAmountScore()
        {
            return _payAmountScore;
        }

        // 总积分个数
        int getScore()
        {
            return _score;
        }
        int getPayScore()
        {
            return _payScore;
        }
        bool enoughScore()
        {
            return _payAmountScore > _needPay;
        }

        // 设置储值金付款金额的最大值
        void setMaxWillPay()
        {
            double willPay = _needPay - _payAmountScore - _payAmountCoupon;
            _maxWillPay = MIN(MAX(willPay, 0), _amount);
        }
        double getMaxWillPay()
        {
            return _maxWillPay;
        }

        // 设置/获得最大可优惠金额
        void setMaxDisAmount(double amount)
        {
            this->_maxDisAmount = amount;
        }
        double getMaxDisAmount()
        {
            return _maxDisAmount;
        }

        // 代金券列表
        void setCouponMap(QMap<QString, Coupon> couponMap)
        {
            this->_couponMap = couponMap;

            _maxPage = (couponMap.count() - 1) / 6 + 1 ;
            _nowPage = -1;
        }

        QMap<QString, Coupon> couponMap()
        {
            return _couponMap;
        }

        QMap<QString, Coupon> selectCouponMap;

        // 代金券总额超过待付时返回true
        bool enoughCoupon()
        {
            _payAmountCoupon = 0.0;
            foreach(auto coupon, selectCouponMap)
            {
                _payAmountCoupon += coupon.disAmount();
            }
            bool isEnough = (_payAmountCoupon > _needPay);
            setMaxWillPay();
            return isEnough;
        }

        double getPayAmountCoupon()
        {
            return _payAmountCoupon;
        }

    private:
        QString _amountStr, _needPayStr;
        double _amount, _needPay;
        int _score, _payScore;
        QMap<QString, Coupon> _couponMap;
        int _maxPage, _nowPage;
        // 代金券金额    使用积分金额     余额将付金额       最大可优惠金额
        double _payAmountCoupon, _payAmountScore, _maxWillPay, _maxDisAmount;
    };

private:
    Ui::FMVipOrder *ui;

    FMVipOrder::OrderInfo *orderInfo;

    QString oldPayText;

    QItemSelectionModel *selectionModel;
    CouponModel *couponModel;

    FMNumPad *_numpad;

    QLineEdit *le;
    QWidget * w;

#ifdef FASTPAY
    QLabel *scanfLabel;
    QLabel *storeLabel;
    QLabel *storeLabel_desc;
    QLineEdit *scanfLe;
    QJsonObject *_json;

#endif
};

#endif // FMVIPORDER_H
