﻿#include "fmviporder.h"
#include "fmmsgwnd.h"
#include "ui_fmviporder.h"
#include "itemdelegate.h"
#include "couponmodel.h"
#include "fmnumpad.h"
#include <QScrollBar>
#include <QItemSelectionModel>
#include <QLabel>

FMVipOrder::FMVipOrder(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipOrder)
{
    ui->setupUi(this);

    _numpad = new FMNumPad(ui->pay_edit, this);

    connect(this, &FMVipOrder::rejected, [=](){
        _numpad->close();
    });
    connect(this, &FMVipOrder::accepted, [=](){
        _numpad->close();
    });

/*条件为1时，表示使用快速支付功能，将原界面price窗口中的控件全部关闭，
 * 然后添加label和lineEdit控件，用于扫描优惠券*/
#ifdef FASTPAY
    ui->price_desc_label->close();
    ui->price_label->close();
    ui->undis_desc_label->close();
    ui->undis_label->close();

    scanfLabel = new QLabel(ui->price);
    scanfLabel->setText(QString::fromLocal8Bit("优惠券扫一扫："));
    scanfLabel->adjustSize();
    scanfLabel->move(150,20);
    scanfLabel->show();

    scanfLe = new QLineEdit(ui->price);
    scanfLe->setMinimumSize(350,30);
    scanfLe->move(300,21);
    scanfLe->show();

    storeLabel = new QLabel(ui->profile);
    storeLabel->move(0,20);
    storeLabel->setMinimumWidth(786);
    storeLabel->setAlignment(Qt::AlignHCenter);


    ui->pay_edit->setFocus();

    ui->pay_max->setText(QString::fromLocal8Bit("订单金额："));
    ui->pay_max->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);

    ui->coupon_desc_label->setText(QString::fromLocal8Bit("优惠券"));
    ui->pay_desc_label->setText(QString::fromLocal8Bit("金额"));
    ui->logo_label->setText(QString::fromLocal8Bit("华润通小助手"));
    ui->pay_btn->setText(QString::fromLocal8Bit("提交"));
    /*将profile界面中的label全部关闭，并插入新的门店信息*/
    ui->balance_label->close();
    ui->balance_desc_label->close();
    ui->name_label->close();
    ui->name_desc_label->close();
    ui->id_label->close();
    ui->id_desc_label->close();
    ui->point_label->close();
    ui->point_desc_label->close();

    ui->title->setStyleSheet("QWidget{background:rgb(255, 170, 0);color:black}");
    ui->pay_btn->setStyleSheet("QPushButton{background:rgb(255, 170, 0)}");

    connect(scanfLe,SIGNAL(returnPressed()),this,SLOT(on_scanfLe_returnPressed()));

#endif



}

FMVipOrder::~FMVipOrder()
{
    del_p(orderInfo);
    delete ui;
    delete _numpad;

#ifdef FASTPAY
    delete scanfLabel;
    delete scanfLe;
#endif
}

bool FMVipOrder::initWnd(Session *session)
{
    this->_session = session;

    QString operator_id = session->data(PosProps.OperatorId).toString();
    QString business_date = session->data(PosProps.BussinessDate).toString();
    QString fm_id = session->data(PosProps.Fm_open_id).toString();
    QString name = session->data(PosProps.Name).toString();
    if(name.isEmpty()) {
        name = "--";
    }
    QString birthday = session->data(PosProps.Birthday).toString();

    QString amount_str = QString::number(session->data(PosProps.Amount).toInt());
    QString score_str = QString::number(session->data(PosProps.Score).toInt());

    int orderAmount = session->data(PosProps.OrderAmount).toInt();
    int needPay = session->data(PosProps.TransAmount).toInt();
    session->addData(PosProps.NeedAmount, needPay);
    QString needPay_str = QString::number(needPay);

    double undisAmount = session->data(PosProps.UndisAmount).toInt()/100.0;
    ui->undis_label->setText(DOUBLE_STR(undisAmount));

    // 积分可抵扣金额（分）
    int score_value = session->data(PosProps.Score).toInt();
    orderInfo = new FMVipOrder::OrderInfo(amount_str, score_value, needPay_str);
    double maxDisAmount = (orderAmount - session->data(PosProps.UndisAmount).toInt()) / 100.0;
    orderInfo->setMaxDisAmount(maxDisAmount);

    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(fm_id);
    ui->point_label->setText(score_str);
    ui->balance_label->setText(orderInfo->getAmountStr());
    ui->price_label->setText(orderInfo->getNeedPayStr());
    ui->name_label->setText(name);

#ifdef FASTPAY
    storeLabel->setText(session->data("PN").toString());
    storeLabel->adjustSize();

#endif

    couponModel = new CouponModel(this);
    ui->coupon_page->setModel(couponModel);
    ItemDelegate *delegate = new ItemDelegate(this);
    ui->coupon_page->setItemDelegate(delegate);
    selectionModel = ui->coupon_page->selectionModel();
    connect(selectionModel, &QItemSelectionModel::selectionChanged, this, &FMVipOrder::onSelectionChanged);

    initCouponItems();

    oldPayText = DOUBLE_STR(orderInfo->getMaxWillPay());
    ui->pay_edit->setText(oldPayText);
    QRegExp regexp("^[0-9]+(.[0-9]{2})?$");
    ui->pay_edit->setValidator(new QRegExpValidator(regexp));
    ui->score_edit->setValidator(new QRegExpValidator(regexp));
    setWillPayText();
    return true;
}

void FMVipOrder::on_pay_btn_clicked()
{
    session()->addData(PosProps.CouponMap, orderInfo->selectCouponMap);
    int codeAmount = ui->pay_edit->text().toDouble()*100;
    session()->addData(PosProps.CodeAmount, codeAmount);
    session()->addData(PosProps.ScoreAmount, orderInfo->getPayScore());

    int payAmount = codeAmount + (orderInfo->getPayAmountScore() + orderInfo->getPayAmountCoupon()) * 100;
    session()->addData(PosProps.Pay_amount, payAmount);

    this->setEnabled(false);

    setIsBusy(true);

    emit pay();
}

//! 点击元素时选中/取消选中代金券
void FMVipOrder::on_coupon_page_clicked(const QModelIndex &index)
{
    // 如果选中状态则取消选中
    if(selectionModel->isSelected(index)) {
        selectionModel->select(index, QItemSelectionModel::Deselect);
    } else {
        // 如果已经有一个选中的，则判断选中的这个是否是不可叠加券
        if(selectionModel->selectedIndexes().length() == 1) {
            QModelIndex firstIndex = selectionModel->selectedIndexes().first();
            if(!couponModel->coupon(firstIndex).isCompatible()) {
//                FMMsgWnd::FailureWnd(QString::fromLocal8Bit("已经选中了一张不可叠加券，不能再选用其他代金券"));
//                return;
                selectionModel->clear();
            }
        }
        Coupon coupon = couponModel->coupon(index);
        // 判断是否满足使用条件
//        if(orderInfo->getMaxDisAmount() < coupon.limitAmount()) {
//            FMMsgWnd::FailureWnd(QString::fromLocal8Bit("该代金券不满足使用条件"));
//            return;
//        }
        // 处理不可叠加券
        if(!coupon.isCompatible()) {
            if(!selectionModel->selectedIndexes().isEmpty()) {
                FMMsgWnd::FailureWnd("该代金券不可与其他代金券叠加使用，请取消选中其他代金券");
                return;
            }
            selectionModel->select(index, QItemSelectionModel::ClearAndSelect);
        } else {
            selectionModel->select(index, QItemSelectionModel::Select);
        }
    }
}


void FMVipOrder::initCouponItems()
{
    orderInfo->setCouponMap(_session->getCouponMap(PosProps.CouponMap));

    foreach(Coupon coupon, orderInfo->couponMap().values())
    {
        if(!couponModel->contains(coupon)) {
            QModelIndex inserIndex = couponModel->push_back(coupon);
#ifdef FASTPAY
            on_coupon_page_clicked(inserIndex);
#endif
        }
    }

//    ui->pay_edit->setFocus();
//    ui->pay_edit->selectAll();
}

void FMVipOrder::onSelectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
{
    foreach (QModelIndex index, selected.indexes()) {
        Coupon coupon = couponModel->coupon(index);
        orderInfo->selectCouponMap[coupon.code()] = coupon;
        orderInfo->setMaxDisAmount(orderInfo->getMaxDisAmount() - coupon.limitAmount());
    }
    foreach (QModelIndex index, deselected.indexes()) {
        Coupon coupon = couponModel->coupon(index);
        orderInfo->selectCouponMap.remove(coupon.code());
        orderInfo->setMaxDisAmount(orderInfo->getMaxDisAmount() + coupon.limitAmount());
    }
    orderInfo->enoughCoupon();
    oldPayText = DOUBLE_STR(orderInfo->getMaxWillPay());
    setWillPayText();
}

void FMVipOrder::setWillPayText()
{
    on_pay_edit_textChanged(oldPayText);

//    ui->pay_edit->setFocus();
//    ui->pay_edit->selectAll();
}

void FMVipOrder::on_coupon_prev_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos - 125);
}

void FMVipOrder::on_coupon_next_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos + 125);
}

void FMVipOrder::on_pay_edit_textChanged(const QString &text)
{
#ifdef FASTPAY
    setRealPay();
#else
    double num = text.toDouble();
    double maxPay = orderInfo->getMaxWillPay();

    if (num > maxPay) {
        QString maxPay_info = QString::fromLocal8Bit("余额只需支付 %1 元");
        if (maxPay >= orderInfo->getAmountStr().toDouble()) {
            maxPay_info = QString::fromLocal8Bit("余额最多支付 %1 元");
        }
        ui->pay_max->setText(maxPay_info.arg(maxPay));
        ui->pay_edit->setText(DOUBLE_STR(maxPay));
    } else {
        oldPayText = text;
        ui->pay_max->setText("");
        ui->pay_edit->setText(text);
    }
#endif
}

void FMVipOrder::on_score_edit_textChanged(const QString &scoreStr)
{
    int score = scoreStr.toInt(0);
    // 不能输入超过总积分
    if(score > orderInfo->getScore()) {
        ui->score_edit->setText(QString::number(orderInfo->getScore()));
        score = orderInfo->getScore();
    }
    // 可用积分数量
    int score_enable = score / 1000 * 1000;  // 以1000的整数倍可抵扣
    orderInfo->setUseScore(score_enable);
    while(orderInfo->enoughScore()) {
        score_enable -= 1000;
        orderInfo->setUseScore(score_enable);
    }

    ui->score_label->setText(QString::fromLocal8Bit("使用 %1 积分抵扣 %2 元").arg(score_enable).arg(orderInfo->getPayAmountScore()));
    oldPayText = DOUBLE_STR(orderInfo->getMaxWillPay());
    setWillPayText();
}

void FMVipOrder::on_pay_key_clicked()
{
    if(_numpad->isVisible()) {
        _numpad->hide();
    } else {
        _numpad->exec();
    }
}

#ifdef FASTPAY
void FMVipOrder::on_scanfLe_returnPressed()
{
    emit couponReq(scanfLe->text());
    scanfLe->clear();
}

void FMVipOrder::setRealPay()
{
    QString orderPayStr = ui->pay_edit->text();
    double orderPay = orderPayStr.toDouble();
    double realPay = orderPay - orderInfo->getPayAmountCoupon();
    ui->standard_label->setText(QString::fromLocal8Bit("实收金额：%1").arg(realPay));
}

#endif

