﻿#include "fmviplogin.h"
#include "ui_fmviplogin.h"
#include "fmvippanel.h"
#include <QFile>
#include <QMutex>
#include "fmloading.h"
#include "fmnumpad.h"

FMVipLogin::FMVipLogin(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipLogin)
{
    ui->setupUi(this);
    _numpad = new FMNumPad(ui->login_edit, this);

    connect(this, &FMVipLogin::rejected, [=](){
        _numpad->close();
    });
    connect(this, &FMVipLogin::accepted, [=](){
        _numpad->close();
    });


}

FMVipLogin::~FMVipLogin()
{
    delete ui;
    delete _numpad;
}

bool FMVipLogin::initWnd(Session *session)
{
    this->_session = session;

    QString placeText;
    if(session->data(PosProps.FM_Type).toInt() == FM_Login) {
        placeText = QString::fromLocal8Bit("输入支付码");
    } else {
        placeText = QString::fromLocal8Bit("输入手机号/会员码/支付码");
    }

#ifdef FASTPAY
    ui->logo_label->setText(QString::fromLocal8Bit("华润通小助手"));
    ui->bd_label->setText(QDateTime::currentDateTime().toString("yyyy-MM-dd"));
    ui->store_label->setText(session->data("SI").toString());
    ui->pos_desc_label->close();
    ui->pos_label->close();
    ui->operator_desc_label->close();
    ui->operator_label->close();
    ui->login_edit->setPlaceholderText(placeText);
    ui->title->setStyleSheet("QWidget{background:rgb(255, 170, 0);border:1px}");
    ui->login_btn->setStyleSheet("QPushButton{background:rgb(255, 170, 0)}");
#else
    ui->store_label->setText(session->data(PosProps.StoreId).toString());
    ui->pos_label->setText(session->data(PosProps.PosId).toString());
    ui->operator_label->setText(session->data(PosProps.OperatorId).toString());
    ui->bd_label->setText(session->data(PosProps.BussinessDate).toString());
    ui->login_edit->setPlaceholderText(placeText);
#endif
    return true;
}

QString FMVipLogin::getVersionInfo()
{
    QByteArray versionInfo;
    QFile versionFile(qApp->applicationDirPath() + "/version.dat");
    bool isOk = versionFile.open(QIODevice::ReadOnly);
    if(isOk) {
        versionInfo = versionFile.readAll();
    } else {
        versionInfo = QString::fromLocal8Bit("未知").toUtf8();
    }
    versionFile.close();
    return versionInfo;
}

void FMVipLogin::on_login_btn_clicked()
{
    QString id = ui->login_edit->text().trimmed();

    _session->addData(PosProps.Member_sign, id);

    this->setEnabled(false);

    setIsBusy(true);

    emit login();
}

void FMVipLogin::resetWnd()
{
    this->setEnabled(true);
    ui->login_edit->clear();
    ui->login_edit->setFocus();
}

void FMVipLogin::on_login_key_clicked()
{
    if(_numpad->isVisible()) {
        _numpad->hide();
    } else {
        _numpad->exec();
    }
}
