#ifndef FMNUMPAD_H
#define FMNUMPAD_H

#include "fmvipwnd.h"
#include <QLineEdit>
#include <QButtonGroup>

namespace Ui {
class FMNumPad;
}

class FMNumPad : public FMVipWnd
{
    Q_OBJECT

public:
    explicit FMNumPad(QDialog *parent = 0);
    FMNumPad(QLineEdit *lineEidt, QDialog *parent = 0);

    ~FMNumPad();

    void setLineEdit(QLineEdit *lineEidt);

private:
    bool initWnd(Session *session);

signals:
    void digit_click(QString keynum);
    void digit_delete();
    void digit_clear();
    void digit_confirm();

private slots:
    void onDigitClicked(QAbstractButton *button);

    void on_backspace_btn_clicked();

    void on_clear_btn_clicked();

    void on_confirm_btn_clicked();

private:
    Ui::FMNumPad *ui;

    QLineEdit *_lineEdit;
    QButtonGroup _btnGroup;
};

#endif // FMNUMPAD_H
