#include "fmnumpad.h"
#include "ui_fmnumpad.h"
#include <QDebug>

FMNumPad::FMNumPad(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMNumPad)
{
    initWnd(nullptr);
}

FMNumPad::FMNumPad(QLineEdit *lineEidt, QDialog *parent):
    _lineEdit(lineEidt),
    FMVipWnd(parent),
    ui(new Ui::FMNumPad)
{
    initWnd(nullptr);
}

bool FMNumPad::initWnd(Session *session)
{
    Q_UNUSED(session)
    ui->setupUi(this);

    setWindowFlags(windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint);

    _btnGroup.addButton(ui->no0);
    _btnGroup.addButton(ui->no1);
    _btnGroup.addButton(ui->no2);
    _btnGroup.addButton(ui->no3);
    _btnGroup.addButton(ui->no4);
    _btnGroup.addButton(ui->no5);
    _btnGroup.addButton(ui->no6);
    _btnGroup.addButton(ui->no7);
    _btnGroup.addButton(ui->no8);
    _btnGroup.addButton(ui->no9);
    _btnGroup.addButton(ui->dot);
    connect(&_btnGroup, static_cast<void(QButtonGroup::*)(QAbstractButton *)>(&QButtonGroup::buttonClicked), this, &FMNumPad::onDigitClicked);

    return true;
}

FMNumPad::~FMNumPad()
{
    delete ui;
}

void FMNumPad::setLineEdit(QLineEdit *lineEidt)
{
    Q_ASSERT(lineEidt!=nullptr);

    this->_lineEdit = lineEidt;
}

void FMNumPad::onDigitClicked(QAbstractButton *button)
{
    QString num_str = button->text();
    emit digit_click(num_str);
    if(_lineEdit != nullptr) {
        _lineEdit->insert(num_str);
        _lineEdit->setFocus();
    }
}

void FMNumPad::on_backspace_btn_clicked()
{
    emit digit_delete();
    if(_lineEdit != nullptr) {
        _lineEdit->backspace();
        _lineEdit->setFocus();
    }
}

void FMNumPad::on_clear_btn_clicked()
{
    emit digit_clear();
    if(_lineEdit != nullptr) {
        _lineEdit->clear();
        _lineEdit->setFocus();
    }
}

void FMNumPad::on_confirm_btn_clicked()
{
    emit digit_confirm();
    if(_lineEdit != nullptr) {
        _lineEdit->setFocus();
    }
}
