﻿#include "couponmodel.h"
#include <QModelIndex>
#include <QDebug>

CouponModel::CouponModel(QObject *parent) : QAbstractListModel(parent)
{

}

int CouponModel::rowCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent)
    return couponList.length();
}

QVariant CouponModel::data(const QModelIndex &index, int role) const
{
    if(!index.isValid()) {
        return QVariant();
    }

    if(role == Qt::TextAlignmentRole) {
        return int(Qt::AlignRight | Qt::AlignVCenter);
    } else if(role == Qt::DisplayRole) {
        QVariant v = QVariant::fromValue(couponList.at(index.row()));
        return v;
    }
    return QVariant();
}

Coupon CouponModel::coupon(const QModelIndex &index)
{
    if(!index.isValid()) {
        return Coupon();
    }

    return couponList.at(index.row());
}

QModelIndex CouponModel::push_back(Coupon coupon)
{
    int rowNum = rowCount();
    QModelIndex beginIndex = index(rowNum);
    beginInsertRows(beginIndex, rowNum, rowNum);
    couponList.append(coupon);
    endInsertRows();
    return this->index(rowNum);
}

bool CouponModel::contains(const Coupon &coupon)
{
    return couponList.contains(coupon);
}
