#include "tasksetstoreinfo.h"
#include "items/storeinfo.h"
#include "dbop.h"

TaskSetStoreInfo::TaskSetStoreInfo(QJsonObject &jsonObj, QObject *parent)
    : FMTaskSimple(jsonObj, FM_Set_Store_Info, 0, parent)
{

}

void TaskSetStoreInfo::packagePOSReq()
{
}

void TaskSetStoreInfo::packagePOSRsp()
{
    FMItem::StoreInfo storeInfo;
    storeInfo.SetPropertiesByJson(posReqJsonObj);
    bool isOk = DBOP::Save(&storeInfo);
    int statusCode = isOk ? FM_API_SUCCESS : FM_API_ERROR;
    QString msg("");
    if(!isOk) {
        msg = QString::fromLocal8Bit("保存门店信息失败");
    }
    posRspJsonObj[PosProps.StatusCode] = statusCode;
    posRspJsonObj[PosProps.Msg] = msg;
}
