﻿#include "taskqrrefund.h"
#include "items/order.h"
#include "items/pay.h"
#include "items/storeinfo.h"
#include "dbop.h"
#include <QJsonDocument>

TaskQRRefund::TaskQRRefund(QJsonObject &jsonObj, FMPePayInterface *epay, Session *session, QObject *parent)
    :FMTaskSimple(jsonObj, FM_QR_Refund, session, parent) ,
      _epay(epay)
{
    Q_ASSERT(_epay != nullptr);
}

void TaskQRRefund::packagePOSReq()
{
    //! WARNING: 现在接口支付传来的POS订单号是transId
    QString orderId = getPosJsonValue(PosProps.TransId).toString();
    FMItem::Order *order = new FMItem::Order();
    DBOP::GetOrderByOrderId(orderId, order);

    QSharedPointer<FMItem::Pay> refundPay;
    QList<QSharedPointer<FMItem::Pay> > pays = DBOP::GetPaysByOrderDBId(order->DBID());
    foreach (QSharedPointer<FMItem::Pay> payPointer, pays) {
        //! WARNING: 临时的找第三方支付的方法
        if(payPointer->transId() == orderId) {
            refundPay = payPointer;
            break;
        }
    }

    QByteArray reqData = QJsonDocument(posReqJsonObj).toJson(QJsonDocument::Compact);
    _epay->DockRefundRequest(reqData);
    _epay->StartService();
    QByteArray rspData = _epay->DockRefundRespond();
    _epay->StopService();
    QJsonDocument json = QJsonDocument::fromJson(rspData);
    posRspJsonObj = json.object();

    if(posRspJsonObj["statusCode"] == FM_API_SUCCESS && refundPay!=nullptr) {
        refundPay->setRefundAmount(refundPay->payAmount());
        bool isOk = DBOP::Save(refundPay.data());
        if(isOk) {
            order->setPaidAmount(order->paidAmount()-refundPay->refundAmount());
        }
    }

    DBOP::Save(order);
    delete order;
}

void TaskQRRefund::packagePOSRsp()
{

}

void TaskQRRefund::stopTask()
{
    FMMsgWnd::WarningWnd(QString::fromLocal8Bit("通讯中断，交易取消"));
    _epay->StopService();
}
