﻿#include "taskqrpay.h"
#include "items/order.h"
#include "items/pay.h"
#include "items/storeinfo.h"
#include "dbop.h"
#include <QJsonDocument>

TaskQRPay::TaskQRPay(QJsonObject &jsonObj, FMPePayInterface *epay, Session *session, QObject *parent)
    :FMTaskSimple(jsonObj, FM_QR_Pay, session, parent) ,
      _epay(epay)
{
    Q_ASSERT(_epay != nullptr);
}

void TaskQRPay::packagePOSReq()
{
    //! WARNING: 现在接口支付传来的POS订单号是transId
    QString orderId = getPosJsonValue(PosProps.TransId).toString();
    FMItem::Order *order = new FMItem::Order();
    DBOP::GetOrderByOrderId(orderId, order);

    if(order->settled()) {
        QString info = QString::fromLocal8Bit("订单已结算，不能再进行支付.");
        FMP_WARN() << info;
        setError(FM_API_ERROR, info);
        return;
    }

    if(order->isNew()) {
        order->SetPropertiesByJson(posReqJsonObj);
        order->setOrderId(orderId);
        DBOP::Save(order);
    }

    QByteArray reqData = QJsonDocument(posReqJsonObj).toJson(QJsonDocument::Compact);
    _epay->DockPayRequest(reqData);
    _epay->StartService();
    QByteArray rspData = _epay->DockPayRespond();
    _epay->StopService();
    QJsonDocument json = QJsonDocument::fromJson(rspData);
    posRspJsonObj = json.object();

    if(posRspJsonObj["statusCode"] == FM_API_SUCCESS) {
        QJsonArray payIds = posRspJsonObj["pay_ids"].toArray();
        foreach (QJsonValue payValue, payIds) {
            QJsonObject payObj = payValue.toObject();
            FMItem::Pay *pay = new FMItem::Pay();
            pay->setPayId(payObj["pay_id"].toString());
            pay->setPayStr(payObj["pay_str"].toString());
            pay->setPayAmount(posRspJsonObj["paid_total_amount"].toInt());
            pay->setAccount(payObj["pay_account"].toString());
            pay->setTransId(posReqJsonObj["trans_id"].toString());
            pay->setFmTransId(posRspJsonObj["fm_id"].toString());
            pay->setThirdTransId(posRspJsonObj["fm_transId"].toString());
            pay->setOrderDBID(order->DBID());
            bool isOk = DBOP::Save(pay);
            if(isOk) {
                order->setPaidAmount(order->paidAmount()+pay->payAmount());
            }
            delete pay;
        }
    }

    DBOP::Save(order);
    delete order;
}

void TaskQRPay::packagePOSRsp()
{

}

void TaskQRPay::stopTask()
{
    FMMsgWnd::WarningWnd(QString::fromLocal8Bit("通讯中断，交易取消"));
    _epay->StopService();
}
