﻿#ifndef TASKPAY_H
#define TASKPAY_H
#include "fmtask.h"
#include "taskothers.h"
#include <QThread>

class TaskCouponThread;

namespace FMItem {
    class Order;
}

class TaskPay : public FMTask
{
    Q_OBJECT
public:
    explicit TaskPay(QJsonObject &jsonObj, Session *session = 0, QObject *parent = 0);
    ~TaskPay();

    void packagePOSReq();
    void setWindow();
    void packageServerReq();
    void packagePOSRsp();

private slots:
    void onPay();
    void onGetCoupons(Session* session);

#ifdef FASTPAY
    void onCouponReq(const QString &code);
#endif // ifdef FASTPAY

private:
    TaskCouponThread *couponThread;
    FMItem::Order *_order;
};

// 加载代金券的线程类
class TaskCouponThread : public QThread
{
    Q_OBJECT
public:
    TaskCouponThread(QJsonObject &jsonObj, Session *session, QObject *parent = 0) {
        _session = session;
        task = new TaskCoupon(jsonObj, session, parent);
    }
    ~TaskCouponThread() {
        del_p(task);
    }

    void run() {
        task->doTask();
        emit finished(_session);
    }

    TaskCoupon *task;
    Session *_session;
signals:
    void finished(Session*);
};
#endif // TASKPAY_H
