﻿#include "taskpay.h"
#include "tasklogin.h"
#include "fmviporder.h"
#include "fmp_logger_i.h"
#include "fmp_vip_settings.h"
#include "fmnetwork.h"
#include "dbop.h"
#include "items/order.h"
#include "items/pay.h"
#include "items/storeinfo.h"
#include <QJsonDocument>
#include <QJsonObject>
#include <QCryptographicHash>
#include "taskothers.h"

using namespace FMItem;

TaskPay::TaskPay(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, FM_Pay, session, parent)
    , _order(new Order(this))
{

}

TaskPay::~TaskPay()
{
    delete _order;
}

void TaskPay::packagePOSReq()
{
#ifdef FASTPAY

#else
    FMItem::StoreInfo storeInfo;
    bool isOk = DBOP::GetLastItem(&storeInfo);
    if(!isOk) {
        QString info = QString::fromLocal8Bit("未设置门店信息，不能再进行支付.");
        FMP_WARN() << info;
        setError(FM_API_ERROR, info);
        return;
    }
    posReqJsonObj = storeInfo.toJson(QStringList(), posReqJsonObj);

    // 检查订单是否已结算
    QString orderId = getPosJsonValue(PosProps.OrderId).toString();
    DBOP::GetOrderByOrderId(orderId, _order);
    if(_order->settled()) {
        QString info = QString::fromLocal8Bit("订单已结算，不能再进行支付.");
        FMP_WARN() << info;
        setError(FM_API_ERROR, info);
        return;
    }
#endif
    QString fm_open_id_pos = getPosJsonValue(PosProps.Fm_open_id).toString();
    QString fm_open_id_session = session()->data(PosProps.Fm_open_id).toString();
    if(fm_open_id_session == "" || fm_open_id_pos!=fm_open_id_session || session()->data(PosProps.CanPay).toBool() == false) {
        preTask = new TaskLogin(posReqJsonObj, _session, this);
        preTask->session()->addData(PosProps.FM_Type, FM_Pay);
        preTask->doTask();
        if(preTask->error() != FM_API_SUCCESS) {
            this->setError(preTask->error(), preTask->errorString());
        }
        this->_session = preTask->session();
    }

    session()->addData(PosProps.OrderAmount, getPosJsonValue(PosProps.OrderAmount).toInt());
    session()->addData(PosProps.TransAmount, getPosJsonValue(PosProps.TransAmount).toInt());
    session()->addData(PosProps.UndisAmount, getPosJsonValue(PosProps.UndisAmount).toInt());

    //! FIXME 启用couponThread线程后，网络异常时setError函数崩溃
//    couponThread = new TaskCouponThread(posReqJsonObj, _session, this);
//    couponThread->start();
//    connect(couponThread, SIGNAL(finished(Session*)), SLOT(onGetCoupons(Session*)));
}

void TaskPay::onGetCoupons(Session* session)
{
    couponThread->exit();

    _session->addData(PosProps.CouponMap, session->getCouponMap(PosProps.CouponMap));
    if(_window != nullptr) {
        qobject_cast<FMVipOrder*>(_window)->initCouponItems();
        _window->setIsBusy(false);
        _window->setEnabled(true);
    }
}

#ifdef FASTPAY

void TaskPay::onCouponReq(const QString &code)
{
    posReqJsonObj[PosProps.Coupon_code] = code;
    TaskCoupon couponTask(posReqJsonObj, this->session());
    qDebug() << couponTask.doTask();

    _session->addData(PosProps.CouponMap, this->session()->getCouponMap(PosProps.CouponMap));
    if(_window != nullptr) {
        qobject_cast<FMVipOrder*>(_window)->initCouponItems();
        _window->setIsBusy(false);
        _window->setEnabled(true);
    }
//    qDebug() << couponTask->getServerJsonValue("");
}

#endif

void TaskPay::setWindow()
{
    _window = new FMVipOrder;

    connect(qobject_cast<FMVipOrder*>(_window), SIGNAL(pay()), this, SLOT(onPay()));
#ifdef FASTPAY

    connect(qobject_cast<FMVipOrder*>(_window),SIGNAL(couponReq(const QString &)),this,SLOT(onCouponReq(const QString &)));

#endif
}

void TaskPay::packageServerReq()
{

#ifdef FASTPAY
//    QJsonObject requestData;
//    requestData[ServerProps(PosProps.ChannelId)] = "APP";
//    requestData[ServerProps(PosProps.IntMerchantCode)] = "2041100001231";
//    requestData[ServerProps(PosProps.SendTime)] = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss:zzz");
//    requestData[ServerProps(PosProps.OutReferNo)] = "1517438482";
//    requestData[ServerProps(PosProps.TransactionUnid)] =  "8207af60bc6e470cbce263414eb1936f";
//    requestData[ServerProps(PosProps.PayChannel)] = "OTHER";
//    requestData[ServerProps(PosProps.SysID)] = "Z1017001";
//    requestData[ServerProps(PosProps.OrderNo)] = "15174384";
//    requestData[ServerProps(PosProps.TransactionTime)] = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss:zzz");
//    requestData[ServerProps(PosProps.MemberId)] =  "6300931545256493073";
//    requestData[ServerProps(PosProps.MerchantCode)] = "2041100001231";
//    requestData[ServerProps(PosProps.StoreCode)] = "01";
//    requestData[ServerProps(PosProps.PayTotalAmount)] = "847.00";
//    requestData[ServerProps(PosProps.TotalPrice)] = "847";

//    QJsonObject request = serverReqJsonObj["REQUEST"].toObject();
//    request[ServerProps(PosProps.RequestData)] = requestData;
//    QJsonObject hrtObj  = request[ServerProps(PosProps.HrtAttrs)].toObject();
//    hrtObj[ServerProps(PosProps.ApiID)] = "crt.ptgw.public.EarnPointsForRSA";
//    hrtObj[ServerProps(PosProps.AppPubID)] = APP_PUB_ID;

//    request[ServerProps(PosProps.HrtAttrs)] = hrtObj;
//    serverReqJsonObj["REQUEST"] = request;
#else
    //! 会员新接口使用 data 打包业务数据
    QJsonObject transData;
    transData[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);

    transData[ServerProps(PosProps.Fm_order_id)] = getPosJsonValue(PosProps.Fm_order_id);
    transData[ServerProps(PosProps.Fm_order_id)] = "";
    transData[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();

    QJsonArray products;
    QJsonArray clientArray = getPosJsonValue("products").toArray();
    for(int i = 0; i < clientArray.size(); i++)
    {
        QJsonObject obj = clientArray[i].toObject();
        QJsonObject serverObj;
        serverObj[ServerProps(PosProps.ConsumeNum)] = obj[PosProps.ConsumeNum];
        int price = obj["price"].toInt();
        serverObj["price"] = price;
        serverObj["productId"] = obj["pid"];
        products.push_back(serverObj);
    }

    QJsonArray payList;
    //余额支付详情
    QJsonObject balance;
    int codeAmount = session()->data(PosProps.CodeAmount).toInt();
    balance["amount"] = codeAmount;
    balance["transId"] = getPosJsonValue("trans_id");
    balance["typeModeFlag"]  = 20001;
    balance["thirdPayTransId"] = "";
    payList.push_back(balance);

    // 积分支付详情
    QJsonObject score;
    int scoreAmount = session()->data(PosProps.ScoreAmount).toInt();
    if(scoreAmount > 0) {
        score["amount"] = scoreAmount;
        score["transId"] = getPosJsonValue("trans_id");
        score["typeModeFlag"] = 20002;
        score["thirdPayTransId"] = "";
        payList.push_back(score);
    }


    //代金券/商品券支付详情
    QMap<QString, QVariant> coupons = session()->data("payCouponMap").toMap();

    // 将代金券按金额从小到大排序
    QList<Coupon> couponList;
    for(QMap<QString, QVariant>::const_iterator it = coupons.constBegin(); it != coupons.constEnd(); it++)
    {
        couponList.append(it.value().value<Coupon>());
    }
    qSort(couponList.begin(), couponList.end(), [=](const Coupon &first, const Coupon &second){
        return (first.disAmount() < second.disAmount());
    });
    // 计算使用的代金券金额

    int needAmount = session()->data(PosProps.NeedAmount).toInt();
    int needCouponAmount = needAmount - codeAmount - scoreAmount;
    int couponAmount = 0;
    foreach(Coupon c, couponList)
    {
        QJsonObject coupon;
//#ifdef FASTPAY
//        int couponDisAmount = c.disAmount() * 100;
//#else
        if(needCouponAmount <= 0) {
            break;
        }
        int couponDisAmount = c.disAmount() * 100;
        if(couponDisAmount <= needCouponAmount) {
            couponDisAmount = couponDisAmount;
            needCouponAmount -= couponDisAmount;
        } else {
            couponDisAmount = MAX(0, needCouponAmount);
            needCouponAmount = 0;
        }
        couponAmount += couponDisAmount;
//#endif
        coupon["amount"] = couponDisAmount;

        coupon["transId"] = getPosJsonValue(PosProps.TransId);
        coupon["typeModeFlag"] = 20003;
        coupon["code"] = c.code();
        payList.push_back(coupon);
    }

    transData["productList"] = products;
    transData["payList"] = payList;
    int payAmount = codeAmount + scoreAmount + couponAmount;
    transData[ServerProps(PosProps.Pay_amount)] = payAmount;

    serverReqJsonObj["data"] = transData;

#endif
}

void TaskPay::packagePOSRsp()
{
#ifdef FASTPAY
//    QJsonValue rspData = getServerJsonValue(PosProps.ReturnCode);
//    qDebug() << "#######################" << rspData.toString();

//    if(rspData.toString() != SUCCESS_CODE)
//    {
//        QString info = QString::fromLocal8Bit("支付失败！");
//        FMP_WARN() << "Login failed: " << info;
//        FMMsgWnd::FailureWnd(info, _window);
//    }

    QJsonObject  json;
    TaskCouponVerify verifyTask(json,_session);
    verifyTask.doTask();
#else
    int status = getServerJsonValue(PosProps.StatusCode).toInt();
    QString orderId = getPosJsonValue(PosProps.OrderId).toString();
    QString transId = getPosJsonValue(PosProps.TransId).toString();
    QString fm_order_id = getServerJsonValue(PosProps.Fm_order_id).toString();
    QString fm_open_id = session()->data(PosProps.Fm_open_id).toString();

    bool isOk = (status == FM_API_SUCCESS);

    posRspJsonObj[PosProps.StatusCode] = status;
    posRspJsonObj[PosProps.Msg] = getServerJsonValue(PosProps.Msg);
    posRspJsonObj[PosProps.Fm_open_id] = fm_open_id;
    posRspJsonObj[PosProps.Fm_order_id] = fm_order_id;
    posRspJsonObj[PosProps.Fm_trans_id] = fm_order_id;

    // 如果订单是新的，则保存在数据库中
    if(isOk && _order->isNew()) {
        _order->SetPropertiesByJson(posReqJsonObj);
        _order->SetPropertiesByJson(posRspJsonObj);

        FMItem::StoreInfo storeInfo;
        DBOP::GetLastItem(&storeInfo);
        _order->setStoreInfoDBID(storeInfo.DBID());

        isOk = DBOP::Save(_order);
    }

    QJsonArray servPayArray = getServerJsonValue("payList").toArray();
    //支付方式描述
    QMap<QString, QString> description;
    description["20001"] = QString::fromLocal8Bit("会员储值金支付");
    description["20002"] = QString::fromLocal8Bit("会员积分支付");
    description["20003"] = QString::fromLocal8Bit("代金券支付");
    description["20004"] = QString::fromLocal8Bit("商品券支付");
    description["20005"] = QString::fromLocal8Bit("现金支付");

    //计算总支付额
    QJsonArray pay_ids;
    int totalPaid = 0;
    for(int i = 0; i < servPayArray.size(); i++)
    {
        QJsonObject pay_id;
        int amount =  servPayArray[i].toObject()[ServerProps(PosProps.Pay_amount)].toInt();
        pay_id[PosProps.Pay_id] = servPayArray[i].toObject()[ServerProps(PosProps.Pay_id)].toString();
        pay_id[PosProps.Pay_str] = description[servPayArray[i].toObject()["typeModeFlag"].toString()];
        pay_id[PosProps.Pay_amount] = amount;
        pay_id[PosProps.Coupon_code] = servPayArray[i].toObject()[ServerProps(PosProps.Coupon_code)].toString();
        pay_ids.push_back(pay_id);

        totalPaid += pay_id[PosProps.Pay_amount].toInt();

        if(isOk && amount!=0) {
            Pay *pay = new Pay();
            pay->SetPropertiesByJson(pay_id);
            pay->setTransId(transId);
            pay->setOrderDBID(_order->DBID());
            pay->setAccount(fm_open_id);
            pay->setFmTransId(transId);
            DBOP::Save(pay);
            _order->setPaidAmount(_order->paidAmount()+amount);
            DBOP::Save(_order);
            delete pay;
        }
    }
    posRspJsonObj[PosProps.PaidAmount] = totalPaid;
    posRspJsonObj[PosProps.Pay_list] = pay_ids;
    posRspJsonObj[PosProps.DisAmount] = 0;
#endif
}

void TaskPay::onPay()
{
    sendToServer();

    if(error() == FM_API_TIMEOUT) {
        FMP_INFO() << "Pay failed: timeout. To reversal.";
        TaskRefundPay taskRefundPay(posReqJsonObj);
        taskRefundPay.doTask();
    }

    _window->accept();
}
