﻿#include "taskothers.h"

TaskCoupon::TaskCoupon(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Coupon, session, parent)
{

}

void TaskCoupon::packageServerReq()
{
#ifdef FASTPAY
//    QJsonObject requestData;
//    requestData[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();
//    requestData[ServerProps(PosProps.Coupon_code)] = getPosJsonValue(PosProps.Coupon_code);
//    requestData[ServerProps(PosProps.MerchantCode)] = getPosJsonValue(PosProps.MerchantCode);

//    QJsonObject request = serverReqJsonObj["REQUEST"].toObject();
//    request[ServerProps(PosProps.RequestData)] = requestData;
//    QJsonObject hrtObj  = request[ServerProps(PosProps.HrtAttrs)].toObject();
//    hrtObj[ServerProps(PosProps.ApiID)] = "crt.cp.public.syncCoupon";
//    hrtObj[ServerProps(PosProps.AppPubID)] = APP_PUB_ID;

//    request[ServerProps(PosProps.HrtAttrs)] = hrtObj;
//    serverReqJsonObj["REQUEST"] = request;
    serverReqJsonObj[PosProps.Partner] = session()->data("PN").toString();
    serverReqJsonObj[PosProps.Code] = session()->data(PosProps.Member_sign).toString();
    serverReqJsonObj[PosProps.TransId] = "201802020001";
    serverReqJsonObj[PosProps.StationId] = "01";
    serverReqJsonObj[PosProps.PartnerId] = session()->data("PI").toString();
    serverReqJsonObj[PosProps.Reqtype] = "0";
    serverReqJsonObj[PosProps.StoreId] = session()->data("SI").toString();
    serverReqJsonObj[PosProps.OperatorId] = "01";
    serverReqJsonObj[PosProps.Ver] = "2";


#else
    QJsonObject data;
    data[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();
//    data[ServerProps(PosProps.Fm_open_id)] = "6524402960";
    // 产品列表
    QJsonArray propducts;
    foreach(QJsonValue pValue, getPosJsonValue(PosProps.Products).toArray())
    {
        QJsonObject po = pValue.toObject();
        QJsonObject spo;
        spo["product_code"] = po[PosProps.ProductId];
        spo["quantity"] = po[PosProps.ConsumeNum];
        spo[ServerProps(PosProps.Price)] = po[PosProps.Price];
        spo["category_code"] = "";
        propducts.append(spo);
    }
    data[ServerProps(PosProps.Products)] = propducts;
    serverReqJsonObj["data"] = data;
#endif
}

void TaskCoupon::packagePOSRsp()
{
    /*单张券查询服务器返回的信息*/
#ifdef FASTPAY
    QJsonValue rspJson = getServerJsonValue("RETURN_CODE");
    qDebug() << "*******************" << rspJson.toString();
    QJsonValue rsp = getServerJsonValue("RETURN_DATA");
    QJsonObject rspData = rsp.toObject();
    QString code = rspData["couponId"].toString();
    QString desc = rspData["couponName"].toString();
    QString type = rspData["couponType"].toString();
    QString amount = rspData["cpValue"].toString();
    double _amount = amount.toDouble();
    QString ableUsed = rspData["ableUsed"].toString();
    QString beginDate = rspData["beginDate"].toString();
    QString couponStatus = rspData["couponStatus"].toString();
    QString endDate = rspData["endDate"].toString();
    QString ownerShopName = rspData["ownerShopName"].toString();
    QString useCondition = rspData["useCondition"].toString();
    double _useCondition = useCondition.toDouble();
    QString openid = rspData["openid"].toString();

    ableUsed = "0";
    /*单张券查询后，根据服务端返回的券的状态进行判断，如券有问题则不添加，没问题则加入到列表中*/
    if(ableUsed.toInt() == 1)
    {
        FMP_WARN() << "Login failed: " << couponStatus;
        FMMsgWnd::FailureWnd(couponStatus, _window);
        return;
    }

    code = getPosJsonValue(PosProps.Coupon_code).toString();
    desc = code;
    _amount = 1;

    Coupon c(desc,code,type,_amount,_useCondition,endDate);
    QVariant v;
    v.setValue(c);
    QMap<QString, QVariant> couponMap;
    couponMap[code] = v;
    session()->addData(PosProps.CouponMap, couponMap);
#else
    QMap<QString, QVariant> couponMap;
    foreach (auto value, getServerJsonValue(PosProps.CouponList).toArray())
    {
        QJsonObject couponOb = value.toObject();
        QString code = couponOb[ServerProps(PosProps.Coupon_code)].toString();
        double amount = couponOb[ServerProps(PosProps.Coupon_disAmount)].toInt() / 100.0;
        QString desc = couponOb["active_name"].toString();
        int type = couponOb[ServerProps(PosProps.Coupon_type)].toInt();
        QString limitTime = couponOb["expiration_date"].toString();

        Coupon c(desc, code, QString::number(type), amount, 0, limitTime, false);
        QVariant v;
        v.setValue(c);
        couponMap[code] = v;
    }
    session()->addData(PosProps.CouponMap, couponMap);
#endif
}


TaskRefundPay::TaskRefundPay(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Refund_Pay, 0, parent)
{

}

void TaskRefundPay::packageServerReq()
{
    QJsonArray transIds;
    transIds.append(getPosJsonValue(PosProps.TransId));
    QJsonObject transData;
    transData["transIds"] = transIds;

    serverReqJsonObj["data"] = transData;
}

void TaskRefundPay::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    foreach(auto prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}

TaskRefundOrder::TaskRefundOrder(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Refund_Order, 0, parent)
{

}

void TaskRefundOrder::packageServerReq()
{
    QJsonObject transData;
    transData[ServerProps(PosProps.Fm_order_id)] = getPosJsonValue(PosProps.Fm_order_id);
    transData[ServerProps(PosProps.OrderId)] = getPosJsonValue(PosProps.OrderId);
    serverReqJsonObj["data"] = transData;
}

void TaskRefundOrder::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    foreach(auto prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}

#ifdef FASTPAY
TaskCouponVerify::TaskCouponVerify(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Verify, session, parent)
{

}

void TaskCouponVerify::packageServerReq()
{
//    QJsonObject requestData;
//    requestData[ServerProps(PosProps.TransactionUnid)] = session()->data(PosProps.TransactionUnid).toString();
//    requestData[ServerProps(PosProps.Cpid)] = session()->data(PosProps.Cpid).toString();
//    requestData[ServerProps(PosProps.MerchantCode)] = getPosJsonValue(PosProps.MerchantCode);
//    requestData[ServerProps(PosProps.CrtMemberid)] = session()->data(PosProps.CrtMemberid).toString();
//    requestData[ServerProps(PosProps.Status)] = "0";

//    QJsonObject request = serverReqJsonObj["REQUEST"].toObject();
//    request[ServerProps(PosProps.RequestData)] = requestData;
//    QJsonObject hrtObj  = request[ServerProps(PosProps.HrtAttrs)].toObject();
//    hrtObj[ServerProps(PosProps.ApiID)] = "crt.cp.public.syncCoupon";
//    hrtObj[ServerProps(PosProps.AppPubID)] = "T000000803LL";
//    request[ServerProps(PosProps.HrtAttrs)] = hrtObj;

//    serverReqJsonObj["REQUEST"] = request;

}


void TaskCouponVerify::packagePOSRsp()
{
    QJsonValue rspJson = getServerJsonValue("RETURN_CODE");
    qDebug() << "$$$$$$$$$$$$$$$$$$$$$" << rspJson.toString();

//    if(rspJson.toString() != SUCCESS_CODE)
//    {
//        FMP_INFO() << "Pay failed: timeout. To reversal.";
//        TaskReverse taskReverse(posReqJsonObj);
//        taskReverse.doTask();
//    }
}



TaskReverse::TaskReverse(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Reverse, session, parent)
{

}

void TaskReverse::packageServerReq()
{
//    QJsonObject requestData;
//    requestData[ServerProps(PosProps.TransactionUnid)] = session()->data(PosProps.TransactionUnid).toString();
//    requestData[ServerProps(PosProps._SysId)] = session()->data(PosProps.Cpid).toString();
//    requestData[ServerProps(PosProps.MerchantCode)] = getPosJsonValue(PosProps.MerchantCode);
//    requestData[ServerProps(PosProps.ChannelId)] = "STORE";
//    requestData[ServerProps(PosProps.StoreCode)] = "01";
//    requestData[ServerProps(PosProps.IntMerchantCode)] = "01";
//    requestData[ServerProps(PosProps.MemberId)] = "01";
//    requestData[ServerProps(PosProps.OutReferNo)] = "01";
//    requestData[ServerProps(PosProps.OrgiOutReferNo)] = "01";
//    requestData[ServerProps(PosProps.OrgiOrderNo)] = "01";
//    requestData[ServerProps(PosProps.TransactionTime)] = "01";
//    requestData[ServerProps(PosProps.SendTime)] ="01" ;
//    requestData[ServerProps(PosProps.Remark)] = "01";

//    QJsonObject request = serverReqJsonObj["REQUEST"].toObject();
//    request[ServerProps(PosProps.RequestData)] = requestData;
//    QJsonObject hrtObj  = request[ServerProps(PosProps.HrtAttrs)].toObject();
//    hrtObj[ServerProps(PosProps.ApiID)] = "crt.ptgw.public.EarnPointsRevertForRSA";
//    hrtObj[ServerProps(PosProps.AppPubID)] = "T000000803LL";
//    request[ServerProps(PosProps.HrtAttrs)] = hrtObj;

//    serverReqJsonObj["REQUEST"] = request;
}

void TaskReverse::packagePOSRsp()
{
    QJsonValue rspJson = getServerJsonValue("RETURN_CODE");
    qDebug() << "*******************" << rspJson.toString();

//    if(rspJson.toString() != SUCCESS_CODE)
//    {
//        FMP_INFO() << "Pay failed: timeout. To reversal.";
//    }
}
#endif
