﻿#include "tasklogin.h"
#include "fmviplogin.h"
#include "fmp_vip_settings.h"
#include "fmp_home_i.h"
#include "fmnetwork.h"
#include <QJsonDocument>
#include "items/storeinfo.h"
#include "dbop.h"

TaskLogin::TaskLogin(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, FM_Login, session, parent)
{
}

void TaskLogin::packagePOSReq()
{
    auto storeInfo = new FMItem::StoreInfo();
    DBOP::GetLastItem(storeInfo);

    posReqJsonObj = storeInfo->toJson(QStringList(), posReqJsonObj);
}

void TaskLogin::setWindow()
{
    _window = new FMVipLogin;

    connect(qobject_cast<FMVipLogin*>(_window), &FMVipLogin::login, this, &TaskLogin::onLogin);
}

void TaskLogin::packageServerReq()
{
#ifdef FASTPAY

//    QJsonObject requestData;
//    requestData[ServerProps(PosProps.TransactionUnid)] = "1234567";
//    requestData[ServerProps(PosProps.MemberVerifyCode)] = session()->data(PosProps.Member_sign).toString();
//    requestData[ServerProps(PosProps.MerchantCode)] = "1651200000001";

//    QJsonObject request = serverReqJsonObj["REQUEST"].toObject();
//    request[ServerProps(PosProps.RequestData)] = requestData;
//    QJsonObject hrtObj  = request[ServerProps(PosProps.HrtAttrs)].toObject();
//    hrtObj[ServerProps(PosProps.ApiID)] = "crt.mb.public.VerifyMemberInfoForOut";
//    hrtObj[ServerProps(PosProps.AppPubID)] = "T000002101DX";
//    request[ServerProps(PosProps.HrtAttrs)] = hrtObj;

//    serverReqJsonObj["REQUEST"] = request;

    QString time = QDateTime::currentDateTime().toString("yyyyMMddhhmmsszzz");
    QString stationId = session()->data("STATIONID").toString();
    QString storeId = session()->data("SI").toString();
    QString transId = stationId + storeId + time;

    serverReqJsonObj[PosProps.Partner] = session()->data("PN").toString();
    serverReqJsonObj[PosProps.Code] = session()->data(PosProps.Member_sign).toString();
    serverReqJsonObj[PosProps.TransId] = transId;
    serverReqJsonObj[PosProps.StationId] = session()->data("STATIONID").toString();
    serverReqJsonObj[PosProps.PartnerId] = session()->data("PI").toString();
    serverReqJsonObj[PosProps.Reqtype] = "0";
    serverReqJsonObj[PosProps.StoreId] = session()->data("SI").toString();
    serverReqJsonObj[PosProps.OperatorId] = session()->data("OPERATORID").toString();;
    serverReqJsonObj[PosProps.Ver] = "2";

#else
    QJsonObject code;
    code[ServerProps(PosProps.Member_sign)] = session()->data(PosProps.Member_sign).toString();
    serverReqJsonObj["data"] = code;
#endif
}

void TaskLogin::packagePOSRsp()
{
    /*会员验证完服务器返回的信息收集*/
#ifdef FASTPAY
//    QJsonValue rspJson = getServerJsonValue("RETURN_CODE");
//    QJsonValue rsp = getServerJsonValue("RETURN_DATA");
//    QJsonObject rspData = rsp.toObject();
//    QString openid = rspData["openid"].toString();
//    double points = rspData["points"].toDouble();
//    posRspJsonObj[ServerProps(PosProps.Fm_open_id)] = "openid";
//    posRspJsonObj[ServerProps(PosProps.Score)] = QString::number(points);


#else
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    p.push_back(PosProps.Fm_open_id);
    p.push_back(PosProps.Amount);
    p.push_back(PosProps.Score);
    p.push_back(PosProps.Sex);
    p.push_back(PosProps.Birthday);
    p.push_back(PosProps.Phone);
    p.push_back(PosProps.Address);
    p.push_back(PosProps.Email);
    foreach (QString prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
#endif
}

void TaskLogin::onLogin()
{
    bool isOk = sendToServer();

    if(!isOk) {
        if(_window != nullptr) {
            _window->accept();
        }
        return;
    }
#ifdef FASTPAY
    if(getServerJsonValue("statusCode").toInt() != SUCCESS_CODE)  {
        QString info = QString::fromLocal8Bit("会员验证失败！");
        FMP_WARN() << "Login failed: " << info;
        FMMsgWnd::FailureWnd(info, _window);
    }
    else  {
        QString openid = getServerJsonValue("openid").toString();

        session()->addData(PosProps.Fm_open_id, openid);

#else
    // 认证失败
    if(getServerJsonValue("statusCode").toInt() != FM_API_SUCCESS) {
        QString info = serverRspJsonObj["msg"].toString();
        FMP_WARN() << "Login failed: " << info;
        FMMsgWnd::FailureWnd(info, _window);
    }
    // 认证成功
    else {
        QString account = getServerJsonValue(PosProps.Fm_open_id).toString();
        QString birthday = getServerJsonValue(PosProps.Birthday).toString();
        if(birthday.isEmpty()) {
            birthday = "--";
        }
        QString name = getServerJsonValue(PosProps.Name).toString();
        if(name.isEmpty()) {
            name = "--";
        }

        bool canPay = (getServerJsonValue(PosProps.CanPay).toInt() == 1);
#ifdef TEST
        canPay = true;
#endif
        if(!canPay) {
            if(getPosJsonValue(PosProps.Fm_cmd).toInt() != FM_Pay) {
                FMMsgWnd::LoginSuccess(account, name, birthday, _window);
            } else {
                FMMsgWnd::FailureWnd(QString::fromLocal8Bit(ErrorNeedPayCode), _window);
                _window->resetWnd();
                return;
            }
        }

        session()->addData(PosProps.Name, name);
        session()->addData(PosProps.Birthday, birthday);
        session()->addData(PosProps.Fm_open_id, account);
        session()->addData(PosProps.Amount, getServerJsonValue(PosProps.Amount).toInt());
        session()->addData(PosProps.Score, getServerJsonValue(PosProps.Score).toInt());
        session()->addData(PosProps.CanPay, canPay);

#endif

        _window->accept();
    }
    if(_window!=nullptr) {
        _window->resetWnd();
    }
}
