﻿#include "taskfund.h"
#include "fmvipfund.h"
#include "tasklogin.h"
#include "items/storeinfo.h"
#include "dbop.h"

TaskFund::TaskFund(QJsonObject &jsonObj, QObject *parent)
    :FMTask(jsonObj, FM_Fund, 0, parent)
{

}

void TaskFund::packagePOSReq()
{
    FMItem::StoreInfo storeInfo;
    bool isOk = DBOP::GetLastItem(&storeInfo);
    if(!isOk) {
        QString info = QString::fromLocal8Bit("未设置门店信息，不能进行充值.");
        FMP_WARN() << info;
        setError(FM_API_ERROR, info);
        return;
    }
    posReqJsonObj = storeInfo.toJson(QStringList(), posReqJsonObj);


    preTask = new TaskLogin(posReqJsonObj, _session, this);
    preTask->session()->addData(PosProps.FM_Type, FM_Fund);
    preTask->doTask();
    if(preTask->error() != FM_API_SUCCESS) {
        this->setError(preTask->error(), preTask->errorString());
    }
}

void TaskFund::setWindow()
{
    _window = new FMVipFund;

    connect(qobject_cast<FMVipFund*>(_window), SIGNAL(fund()), this, SLOT(onFund()));

    session()->addData(PosProps.ChargeAmount, getPosJsonValue(PosProps.ChargeAmount));
}

void TaskFund::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.OrderId);
    QJsonObject trans;
    trans[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();
    trans[ServerProps(PosProps.ChargeAmount)] = session()->data(PosProps.ChargeAmount).toInt();
    QJsonObject payCash;
    payCash[ServerProps(PosProps.Amount)] = session()->data(PosProps.ChargeAmount).toInt();
    payCash[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.OrderId);
    payCash[ServerProps(PosProps.Type_code)] = "10001";
    QJsonArray payList;
    payList.append(payCash);
    trans[ServerProps(PosProps.Pay_list)] = payList;
    serverReqJsonObj["data"] = trans;
}

void TaskFund::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    p.push_back(PosProps.Fm_order_id);
    p.push_back(PosProps.Print);
    foreach (QString prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Fm_open_id] = session()->data(PosProps.Fm_open_id).toString();
}

void TaskFund::onFund()
{
    sendToServer();
    _window->accept();
}
