﻿#include "fmtasknownd.h"
#include "fmp_vip_settings.h"
#include <QJsonDocument>

FMTaskNoWnd::FMTaskNoWnd(QJsonObject &jsonObj, FM_TYPE fmType, Session *session, QObject *parent) :
    FMTask(jsonObj, fmType, session, parent)
{

}

QByteArray FMTaskNoWnd::doTask()
{
#ifdef FM_DEBUG
    if(!checkReqJson()) {
        return errorStringJson().toUtf8();
    }
#endif
    RunFunction(packagePOSReq);
#ifdef FASTPAY
#else
    RunFunction(copyPros);
#endif
    bool isOk = sendToServer();
    if(!isOk) {
        FMP_WARN() << QString("Task error %1: %2").arg(error()).arg(errorString());
        return errorStringJson().toUtf8();
    }
    RunFunction(packagePOSRsp);

    QJsonDocument json(posRspJsonObj);
    return json.toJson(QJsonDocument::Compact);
}
