#ifndef PRODUCT_H
#define PRODUCT_H
#include "item.h"

namespace FMItem {

    class Product : public Item
    {
        Q_OBJECT

        Q_PROPERTY(QString id READ id WRITE setId)
        Q_PROPERTY(int quantity READ quantity WRITE setQuantity)
        Q_PROPERTY(int price READ price WRITE setPrice)
        Q_PROPERTY(QString name READ name WRITE setName)
    public:
        explicit Product(QObject *parent = 0);
        virtual ~Product();

        int quantity() const;
        void setQuantity(int quantity);

        int price() const;
        void setPrice(int price);

        QString name() const;
        void setName(const QString &name);

        QString id() const;
        void setId(const QString &id);

    private:
        QString _id;
        int _quantity;
        int _price;
        QString _name;
    };
}

#endif // PRODUCT_H
