#ifndef PAY_H
#define PAY_H
#include "item.h"
#include "global.h"

namespace FMItem {

    class Pay : public Item
    {
        Q_OBJECT

        Q_PROPERTY(QString pay_id READ payId WRITE setPayId)
        Q_PROPERTY(QString pay_str READ payStr WRITE setPayStr)
        Q_PROPERTY(int pay_amount READ payAmount WRITE setPayAmount)
        Q_PROPERTY(int refund_amount READ refundAmount WRITE setRefundAmount)
        Q_PROPERTY(int dis_amount READ disAmount WRITE setDisAmount)
        Q_PROPERTY(QString account READ account WRITE setAccount)
        Q_PROPERTY(QString trans_id READ transId WRITE setTransId)
        Q_PROPERTY(QString fm_trans_id READ fmTransId WRITE setFmTransId)
        Q_PROPERTY(QString third_trans_id READ thirdTransId WRITE setThirdTransId)
        Q_PROPERTY(int orderDBID READ orderDBID WRITE setOrderDBID)
    public:
        explicit Pay(QObject *parent = 0);
        virtual ~Pay();

        QString payId() const;
        void setPayId(const QString &payId);

        QString payStr() const;
        void setPayStr(const QString &payStr);

        int payAmount() const;
        void setPayAmount(int payAmount);

        int disAmount() const;
        void setDisAmount(int disAmount);

        QString account() const;
        void setAccount(const QString &account);

        QString transId() const;
        void setTransId(const QString &transId);

        QString fmTransId() const;
        void setFmTransId(const QString &fmTransId);

        int orderDBID() const;
        void setOrderDBID(int orderDBID);

        int refundAmount() const;
        void setRefundAmount(int refundAmount);

        QString thirdTransId() const;
        void setThirdTransId(const QString &thirdTransId);

    private:
        QString _payId;
        QString _payStr;
        int _payAmount;
        int _refundAmount;
        int _disAmount;

        QString _account;
        QString _transId;
        QString _fmTransId;
        QString _thirdTransId;

        int _orderDBID;
    };
}

#endif // PAY_H
