#ifndef ORDER_H
#define ORDER_H

#include "item.h"
#include <QList>
#include <QJsonObject>

namespace FMItem {

    class Pay;
    class Product;

    typedef QList<Pay *> PayList;
    typedef QList<Product *> ProductList;

    class Order : public Item
    {
        Q_OBJECT

        Q_PROPERTY(QString order_id READ orderId WRITE setOrderId)
        Q_PROPERTY(QString fm_order_id READ fmOrderId WRITE setFmOrderId)
        Q_PROPERTY(int order_amount READ orderAmount WRITE setOrderAmount)
        Q_PROPERTY(int paid_amount READ paidAmount WRITE setPaidAmount)
        Q_PROPERTY(int undis_amount READ undisAmount WRITE setUndisAmount)
        Q_PROPERTY(QString fm_open_id READ fmOpenId WRITE setFmOpenId)
        Q_PROPERTY(QString products READ productText WRITE setProductText)
        Q_PROPERTY(bool settled READ settled WRITE setSettled)
        Q_PROPERTY(bool refunded READ refunded WRITE setRefunded)
        Q_PROPERTY(int storeInfoDBID READ storeInfoDBID WRITE setStoreInfoDBID)
//        Q_PROPERTY(ItemList payList READ payList WRITE setPayList)
//        Q_PROPERTY(ProductList productList READ productList WRITE setProductList)
    public:
        explicit Order(QObject *parent = 0);

        virtual ~Order();

        QString orderId() const;
        void setOrderId(const QString &orderId);

        QString fmOrderId() const;
        void setFmOrderId(const QString &fmOrderId);

        int orderAmount() const;
        void setOrderAmount(int orderAmount);

        int paidAmount() const;
        void setPaidAmount(int paidAmount);

        int undisAmount() const;
        void setUndisAmount(int undisAmount);

        QString fmOpenId() const;
        void setFmOpenId(const QString &fmOpenId);

        ItemList payList() const;
        void setPayList(const ItemList &payList);

        ProductList productList() const;
        void setProductList(const ProductList &productList);

        QString productText() const;
        void setProductText(const QString &productText);

        bool settled() const;
        void setSettled(bool settled);

        int storeInfoDBID() const;
        void setStoreInfoDBID(int storeInfoDBID);

        bool refunded() const;
        void setRefunded(bool refunded);

    private:
        QString _orderId;
        QString _fmOrderId;
        int _orderAmount;
        int _paidAmount;
        int _undisAmount;

        QString _fmOpenId;

        QString _productText;

        bool _settled;
        bool _refunded;

        int _storeInfoDBID;

        ItemList _payList;
        ProductList _productList;
    };
}

#endif // ORDER_H
