﻿#ifndef ITEM_H
#define ITEM_H

#include <QObject>
#include <QJsonObject>
#include <QSqlRecord>

namespace FMItem {

    class Item;

    typedef QList<Item *> ItemList;

    class Item : public QObject
    {
        Q_OBJECT

        Q_PROPERTY(int DBID READ DBID WRITE setDBID)
    public:
        explicit Item(QObject *parent = 0);
        explicit Item(const QJsonObject &json, QObject *parent = 0);

        virtual ~Item();

        void SetPropertiesByJson(const QJsonObject &json);
        void SetPropertiesByJson(const QByteArray &json);
        void SetPropertiesBySqlRecord(const QSqlRecord &record);

        QJsonObject toJson(QStringList keys = QStringList(), QJsonObject json = QJsonObject());
        /**
         * @brief toJson
         * @param key2property  map的key为json的key，map的vlue为item的property名
         * @param json          在此json基础上修改/新增json的键值
         * @return
         */
        QJsonObject toJson(QMap<QString, QString> key2property, QJsonObject json = QJsonObject());

        QString ShortClassName() const;

        int PropertyCount() const;
        QStringList PropertyNames() const;

        int DBID() const;
        void setDBID(int DBID);

        virtual bool isEqual(const Item *other);

        /**
         * @brief isNew
         * @return
         * 是否是新的，即是否已经在数据库中存在
         */
        bool isNew();

    private:
        int _DBID;
    };
}

#endif // ITEM_H
