﻿#include <QMenu>
#include <QAction>
#include <QTimer>
#include <QJsonParseError>
#include "fmp_vip_settings.h"
#include <winsock2.h>
#include "fmvipdispatcher.h"
#include "fmtask.h"
#include "taskfactory.h"
#include "fmp_vip_server.h"
#include "tasklogin.h"
#include "taskpay.h"
#include "tasklist.h"
#include "taskothers.h"
#include "taskfinal.h"
#include "taskrefund.h"
#include "taskfund.h"
#include "tasksetstoreinfo.h"
#include "taskqrpay.h"
#include "taskqrrefund.h"
#include <ctkPluginContext.h>
#undef StartService
#include <fmp_epay_i.h>
#include <fmp_home_i.h>
#include "fmp_redeem_i.h"
#include "dbop.h"
#include "items/storeinfo.h"

FMVipDispatcher::FMVipDispatcher(QObject *parent) :
    QObject(parent),
    fmTask(nullptr),
    _ctx(nullptr)
{
}

FMVipDispatcher::~FMVipDispatcher()
{
    if(fmTask!=nullptr) {
        fmTask->deleteLater();
    }
}

void FMVipDispatcher::doTask(const QByteArray &reqData, QByteArray &rspData)
{
    FMP_INFO() << "Recv POS reqData: " << reqData;

    // 如果Session已经超过60秒，则清空
    if(session.createdTime().secsTo(QDateTime::currentDateTime()) > 60) {
        session.clear();
    }
    
    QJsonParseError error;
    QJsonDocument doc = QJsonDocument::fromJson(reqData, &error);
    if(error.error != QJsonParseError::NoError) {
        FMP_ERROR() << "Parse req json error: " << error.errorString();
        rspData = QString::fromLocal8Bit("{\"msg:\":\"请求数据解析失败：\"}").arg(error.errorString()).toUtf8();
        return;
    }
    QJsonObject jsonObj = doc.object();
    FM_TYPE type = (FM_TYPE)jsonObj["fm_cmd"].toInt();
    
    switch (type) {
    case FM_Set_Store_Info: {
//        TaskSetStoreInfo taskSetStoreInfo(jsonObj);
//        rspData = taskSetStoreInfo.doTask();
        fmTask = new TaskSetStoreInfo(jsonObj);
        rspData = fmTask->doTask();
        break;
    }
    case FM_Login: {
//        TaskLogin taskLogin(jsonObj, &session);
//        rspData = taskLogin.doTask();
        fmTask = new TaskLogin(jsonObj, &session);
        rspData = fmTask->doTask();
        session.resetCreatedTime();
        break;
    }
    case FM_Pay: {
//        TaskPay taskPay(jsonObj, &session);
//        rspData = taskPay.doTask();

        if (_ctx) {
            ctkServiceReference ref =_ctx->getServiceReference<FMPHomeInterface>();
            FMPHomeInterface *home = _ctx->getService<FMPHomeInterface>(ref);
            if(home) {

                QString pn = home->partnerName();
                QString pi = home->partnerId();
                QString sn = home->storeName();
                QString sl = home->storeId();
                QString dl = home->deviceId();
                QString dn = home->deviceName();
                QString stationId = home->stationId();
                QString operatorId = home->operatorId();

                session.addData("PN", pn);
                session.addData("PI", pi);
                session.addData("SN", sn);
                session.addData("SI", sl);
                session.addData("DI", dl);
                session.addData("DN", dn);
                session.addData("STATIONID",stationId);
                session.addData("OPERATORID",operatorId);

            }
        }
        fmTask = new TaskPay(jsonObj, &session);
        rspData = fmTask->doTask();
        session.clear();
        break;
    }
#ifdef FASTPAY
    case FM_List: {
        fmTask = new TaskList(jsonObj, &session);
        rspData = fmTask->doTask();
        session.clear();
        break;
    }
#endif
    case FM_QR_Pay: {
        if (_ctx) {
            ctkServiceReference ref =_ctx->getServiceReference<FMPePayInterface>();
            FMPePayInterface *epay = _ctx->getService<FMPePayInterface>(ref);
//            epay->DockPayRequest(reqData);
//            epay->StartService();
//            rspData = epay->DockPayRespond();
//            epay->StopService();
//            TaskQRPay taskEPay(jsonObj, epay);
//            rspData = taskEPay.doTask();
            fmTask = new TaskQRPay(jsonObj, epay);
            rspData = fmTask->doTask();
        }
        else {
            rspData = QString::fromLocal8Bit("{\"msg:\":\"支付服务不可用\"}").toUtf8();
        }
        break;
    }
    case FM_QR_QUERY: {
        if (_ctx) {
            ctkServiceReference ref =_ctx->getServiceReference<FMPePayInterface>();
            FMPePayInterface *epay = _ctx->getService<FMPePayInterface>(ref);
            epay->DockQueryRequest(reqData);
            epay->StartService();
            rspData = epay->DockQueryRespond();
            epay->StopService();
        }
        else {
            rspData = QString::fromLocal8Bit("{\"msg:\":\"查询服务不可用\"}").toUtf8();
        }
        break;
    }
    case FM_Coupon_Pay:{
        if(_ctx){
            ctkServiceReference ref = _ctx->getServiceReference<FMPRedeemInterface>();
            FMPRedeemInterface* redeem = _ctx->getService<FMPRedeemInterface>(ref);

            FMItem::StoreInfo storeInfo;
            bool isOk = DBOP::GetLastItem(&storeInfo);
            if(!isOk) {
                rspData = QString::fromLocal8Bit(ErrorMsgJson).arg(FM_API_ERROR).arg(QString::fromLocal8Bit("未设置门店信息，不能进行支付.")).toUtf8();
            } else {
                jsonObj[PosProps.StoreId] = storeInfo.storeId();
#ifdef FM_DEBUG
                jsonObj[PosProps.StoreId] = "fm99999";
#endif
                jsonObj[PosProps.PosId] = storeInfo.posId();
                jsonObj[PosProps.OperatorId] = storeInfo.operatorId();
                jsonObj[PosProps.PartnerId] = FMPVipSettings::instance()->GetPayPartnerId();
                QJsonObject result = redeem->Redeem(jsonObj);
                rspData = QJsonDocument(result).toJson(QJsonDocument::Compact);
            }
        }
        else{
            rspData = QString::fromLocal8Bit("{\"msg:\":\"卡券服务不可用\"}").toUtf8();
        }
        break;
    }
    case FM_Refund: {
//        TaskRefund taskRefund(jsonObj);
//        rspData = taskRefund.doTask();
        fmTask = new TaskRefund(jsonObj);
        rspData = fmTask->doTask();
        break;
    }
//    case FM_Order_Revoke: {
//        TaskRefundPay taskRefundPay(jsonObj);
//        rspData = taskRefundPay.doTask();
//        break;
//    }
    case FM_QR_Refund: {
        if (_ctx) {
            ctkServiceReference ref =_ctx->getServiceReference<FMPePayInterface>();
            FMPePayInterface *epay = _ctx->getService<FMPePayInterface>(ref);
//            epay->DockRefundRequest(reqData);
//            epay->StartService();
//            rspData = epay->DockRefundRespond();
//            epay->StopService();
//            TaskQRRefund taskEPayRefund(jsonObj, epay);
//            rspData = taskEPayRefund.doTask();
            fmTask = new TaskQRRefund(jsonObj, epay);
            rspData = fmTask->doTask();
        }
        else {
            rspData = QString::fromLocal8Bit("{\"msg:\":\"退款服务不可用\"}").toUtf8();
        }
        break;
    }
    case FM_Final: {
//        TaskFinal taskFinal(jsonObj, &session);
//        rspData = taskFinal.doTask();
        fmTask = new TaskFinal(jsonObj, &session);
        rspData = fmTask->doTask();
        session.clear();
        break;
    }
    case FM_Fund: {
//        TaskFund taskFund(jsonObj);
//        rspData = taskFund.doTask();
        fmTask = new TaskFund(jsonObj);
        rspData = fmTask->doTask();
        break;
    }
    default:
        rspData = QString::fromLocal8Bit("{\"msg:\":\"未知的请求类型\"}").toUtf8();
        break;
    }

    if(fmTask!=nullptr) {
        fmTask->deleteLater();
        fmTask = nullptr;
    }

    FMP_INFO() << "Send to pos: " << rspData;
}

void FMVipDispatcher::setPluginContext(ctkPluginContext *ctx)
{
    if (ctx && _ctx != ctx) {
        try {
            //! Verify pointer
            ctx->getPlugin();
            _ctx = ctx;
        }
        catch(const ctkException&) {
            FMP_ERROR() << "Invalid context:" << ctx;
        }
    }
}

void FMVipDispatcher::stopTask()
{
    if(fmTask!=nullptr) {
        fmTask->stopTask();
    }
}
