﻿#ifndef FMP_VIP_SERVER_H
#define FMP_VIP_SERVER_H

#include <QTcpServer>

#define FMSOCKFLAG 0x4d46

class FMVipDispatcher;
class ctkPluginContext;

typedef struct {
    int flag;
    int ver;
    int len;
}FMSOCKEHEADER;

class FMPVipServer : public QTcpServer
{
    Q_OBJECT
public:
    static FMPVipServer *instance();
    ~FMPVipServer();

    void Listen(quint16 port);
    void Write(const QByteArray &data);

    void SetPluginContext(ctkPluginContext *ctx);

    void callVipPay(const QByteArray &reqData, QByteArray &rspData);

signals:
    void SocketDisconnected();

private slots:
    void onNewConnection();
    void onDisconnected();
    void onReadyRead();

private:
    explicit FMPVipServer();

    QTcpSocket *socket;
    FMVipDispatcher *dispatcher;

    bool isNeedSocketHeader;
};

#endif // FMP_VIP_SERVER_H
