#ifndef DBOP_H
#define DBOP_H

#include <QObject>
#include <QVector>
#include "global.h"

#define TABLE_PAY       "Pay"
#define TABLE_ORDER     "Order"
#define TABLE_STOREINFO "StoreInfo"
#define TABLE_SCORELIST "ScoreList"

namespace FMItem {
class Item;
class Order;
class Pay;
class StoreInfo;
class ScoreList;
}

class FMPDataBase;

class DBOP
{
public:
    static DBOP *Instance();

    static bool Save(FMItem::Item *item);

    static void InsertTablePay(const QString &transId, const QString &fmId, const QByteArray &reqData, const QByteArray &rspData);
    static void InsertTableOrder(const QString &transId, const QString &fmId, const QByteArray &reqData, const QByteArray &rspData);

    static void GetOrderByOrderId(const QString &orderId, FMItem::Order *order);
    static QSharedPointer<FMItem::Order> GetOrderByOrderId(const QString &orderId);
    static void GetOrderByDBId(unsigned int DBID, FMItem::Order* order);
    static QSharedPointer<FMItem::Order> GetOrderByDBId(unsigned int DBID);

    static QList<QSharedPointer<FMItem::Pay> > GetPaysByOrderDBId(int orderDBID);
    static void GetPayByDBId(unsigned int DBID, FMItem::Pay *pay);
    static QSharedPointer<FMItem::Pay> GetPayByDBId(unsigned int DBID);

    static void GetListByListId(const QString &listId, FMItem::ScoreList *scoreList);
    static QSharedPointer<FMItem::ScoreList> GetListByListId(const QString &scoreId);
    static void GetListByDBId(unsigned int DBID, FMItem::ScoreList* scoreList);
    static QSharedPointer<FMItem::ScoreList> GetListByDBId(unsigned int DBID);

    static bool GetLastItem(FMItem::Item *item);
//    template<typename T>
//    static QSharedPointer<T> GetLastItem();

    static bool GetItemByDBID(unsigned int DBID, FMItem::Item *item);

private:
    DBOP();
    FMPDataBase *_db;

    static void InserTable(const QString &tableName, const QString &transId, const QString &fmId, const QByteArray &reqData, const QByteArray &rspData);

    bool CreateTable(const QString &tableName);
    bool ExistTable(const QString &tableName);

    int GetLastInsertId();
};

#endif // DBOP_H
