﻿#ifndef FMP_VIP_I_H
#define FMP_VIP_I_H

#include <fmp_plugin_i.h>

/**
 * 业务插件接口，必须继承自 FMPluginInterface
 * @brief The FMPVipInterface class
 */
class FMPVipInterface : public QObject, public FMPluginInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPluginInterface)
public:
    explicit            FMPVipInterface(ctkPluginContext *ctx) : FMPluginInterface(ctx)
    {
        connect(this, &FMPVipInterface::TriggerInit, this, &FMPVipInterface::OnTriggerInit);
        connect(this, &FMPVipInterface::TriggerUninit, this, &FMPVipInterface::OnTriggerUninit);
    }
    virtual void pay() = 0;
    virtual void list() = 0;
signals:
    void                TriggerInit();
    void                TriggerUninit();

protected slots:
    void                OnTriggerInit() { FMPluginInterface::OnTriggerInit(); }
    void                OnTriggerUninit() { FMPluginInterface::OnTriggerUninit(); }
};

Q_DECLARE_INTERFACE(FMPVipInterface, "com.fmp.vip")


#endif // FMP_LOGGER_I_H
