﻿#include "taskpay.h"
#include "tasklogin.h"
#include "fmviporder.h"
#include "fmp_logger_i.h"
#include "fmp_vip_settings.h"
#include "fmnetwork.h"
#include <QJsonDocument>
#include <QJsonObject>
#include <QCryptographicHash>

TaskPay::TaskPay(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, FM_Pay, session, parent)
{
}

TaskPay::~TaskPay()
{
    del_p(_window);
}

QByteArray TaskPay::doTask()
{    
    FMP_DEBUG() << __FUNCTION__;
    //获取可用的代金券
//    TaskCoupon taskCoupon(posReqJsonObj, _session);
//    QByteArray ret = taskCoupon.doTask();
//    if(taskCoupon.error() != FM_API_SUCCESS)
//    {
//        return ret;
//    }

    QString fm_open_id_pos = getPosJsonValue(PosProps.Fm_open_id).toString();
    QString fm_open_id_session = session()->data(PosProps.Fm_open_id).toString();
    if(fm_open_id_session == "" || fm_open_id_pos!=fm_open_id_session || session()->data(PosProps.CanPay).toBool() == false) {
        preTask = new TaskLogin(posReqJsonObj, _session, this);
        preTask->session()->addData(PosProps.FM_Type, FM_Pay);
        QByteArray loginRst = preTask->doTask();
        if(preTask->error() != FM_API_SUCCESS || (session()->contains(PosProps.StatusCode) && session()->data(PosProps.StatusCode).toInt()!=FM_API_SUCCESS)) {
            return loginRst;
        }
        this->_session = preTask->session();
    }


//    couponThread = new TaskCouponThread(posReqJsonObj, _session, this);
//    couponThread->start();
//    connect(couponThread, SIGNAL(finished(Session*)), SLOT(onGetCoupons(Session*)));
    return FMTask::doTask();
}

void TaskPay::onGetCoupons(Session* session)
{
//    couponThread->exit();

    _session->addData(PosProps.CouponMap, session->getCouponMap(PosProps.CouponMap));
    if(_window != nullptr) {
        qobject_cast<FMVipOrder*>(_window)->initCouponItems();
        _window->setIsBusy(false);
        _window->setEnabled(true);
    }
}

void TaskPay::setWindow()
{
    _window = new FMVipOrder;
    int amount = getPosJsonValue(PosProps.OrderAmount).toInt();
    if (amount == 0) {
        amount = getPosJsonValue(PosProps.OrderAmount).toDouble();
    }

    //! 临时取 OrderAmount !!!!
    int paid_amount = getPosJsonValue(PosProps.OrderAmount).toInt();
    if (paid_amount == 0) {
        paid_amount = getPosJsonValue(PosProps.OrderAmount).toDouble();
    }
    session()->addData(PosProps.OrderAmount, amount);
    session()->addData(PosProps.OrderAmount, paid_amount);

    connect(qobject_cast<FMVipOrder*>(_window), SIGNAL(pay()), this, SLOT(onPay()));
}

void TaskPay::packageServerReq()
{
    //! 会员新接口使用 data 打包业务数据
    QJsonObject transData;
    transData[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);

    transData[ServerProps(PosProps.Fm_id)] = getPosJsonValue(PosProps.Fm_id);
    transData[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();

    QJsonArray products;
    QJsonArray clientArray = getPosJsonValue("products").toArray();
    for(int i = 0; i < clientArray.size(); i++)
    {
        QJsonObject obj = clientArray[i].toObject();
        QJsonObject serverObj;
        serverObj["consumeNum"] = obj["consume_num"];
        int price = obj["price"].toString().toDouble()*100;
        serverObj["price"] = price;
        serverObj["productId"] = obj["pid"];
        products.push_back(serverObj);
    }

    QJsonArray payList;
    //余额支付详情
    QJsonObject balance;
    int codeAmount = session()->data(PosProps.CodeAmount).toInt();
    balance["amount"] = codeAmount;
    balance["transId"] = getPosJsonValue("trans_id");
    balance["typeModeFlag"]  = 20001;
    balance["thirdPayTransId"] = "";
    payList.push_back(balance);

    // 积分支付详情
    QJsonObject score;
    int scoreAmount = session()->data(PosProps.ScoreAmount).toInt();
    score["amount"] = scoreAmount;
    score["transId"] = getPosJsonValue("trans_id");
    score["typeModeFlag"] = 20002;
    score["thirdPayTransId"] = "";
    payList.push_back(score);

    //代金券/商品券支付详情
    QMap<QString, QVariant> coupons = session()->data("payCouponMap").toMap();
    for(QMap<QString, QVariant>::const_iterator it = coupons.constBegin(); it != coupons.constEnd(); it++)
    {
        QJsonObject coupon;
        int couponAmount = it.value().value<Coupon>().disAmount();
        coupon["amount"] = couponAmount;
        coupon["transId"] = getPosJsonValue(PosProps.TransId);
        coupon["typeModeFlag"] = it.value().value<Coupon>().typeModeFlag();
        coupon["code"] = it.value().value<Coupon>().code();
        payList.push_back(coupon);
    }

    transData["productList"] = products;
    transData["payList"] = payList;

    transData[ServerProps(PosProps.Pay_amount)] = session()->data(PosProps.Pay_amount).toInt();
    serverReqJsonObj["data"] = transData;
}

void TaskPay::packagePOSRsp()
{
    posRspJsonObj[PosProps.StatusCode] = getServerJsonValue(PosProps.StatusCode);
    posRspJsonObj[PosProps.Msg] = getServerJsonValue(PosProps.Msg);
    posRspJsonObj[PosProps.Prompt] = 0;
    posRspJsonObj[PosProps.Settlement] = 1;
    posRspJsonObj[PosProps.Fm_open_id] = session()->data(PosProps.Fm_open_id).toString();
    posRspJsonObj[PosProps.Fm_id] = getServerJsonValue(PosProps.Fm_id).toString();

    QJsonArray servPayArray = getServerJsonValue("payList").toArray();
    //支付方式描述
    QMap<QString, QString> description;
    description["20001"] = QString::fromLocal8Bit("会员储值金支付");
    description["20002"] = QString::fromLocal8Bit("会员积分支付");
    description["20003"] = QString::fromLocal8Bit("代金券支付");
    description["20004"] = QString::fromLocal8Bit("商品券支付");
    description["20005"] = QString::fromLocal8Bit("现金支付");

    //计算总支付额
    QJsonArray pay_ids;
    int totalPaid = 0;
    for(int i = 0; i < servPayArray.size(); i++)
    {
        QJsonObject pay_id;
        pay_id[PosProps.Pay_id] = servPayArray[i].toObject()[ServerProps(PosProps.Pay_id)].toString();
        pay_id[PosProps.Pay_str] = description[servPayArray[i].toObject()["typeModeFlag"].toString()];
        pay_id[PosProps.Pay_amount] = servPayArray[i].toObject()[ServerProps(PosProps.Pay_amount)].toInt();
        pay_id[PosProps.Coupon_code] = servPayArray[i].toObject()[ServerProps(PosProps.Coupon_code)].toString();
        pay_ids.push_back(pay_id);

        totalPaid += pay_id[PosProps.Pay_amount].toInt();
    }
    posRspJsonObj[PosProps.Paid_total_amount] = totalPaid;
    posRspJsonObj[PosProps.Pay_ids] = pay_ids;
}

void TaskPay::onPay()
{
    sendToServer();

    if(error() == FM_API_TIMEOUT) {
        FMP_INFO() << "Pay failed: timeout. To reversal.";
        TaskRefundPay taskRefundPay(posReqJsonObj);
        taskRefundPay.doTask();
    }

    _window->accept();
}
