﻿#include "taskothers.h"
#include "fmbackup.h"

TaskCoupon::TaskCoupon(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Coupon, session, parent)
{

}

void TaskCoupon::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.Coupon)] = getPosJsonValue(PosProps.Coupon);
}

void TaskCoupon::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.Fm_open_id);
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);

    foreach(auto prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    posRspJsonObj["pid"] = serverRspJsonObj["productCode"];
    posRspJsonObj[PosProps.Prompt] = 1;
}

TaskRefundPay::TaskRefundPay(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Refund_Pay, 0, parent)
{

}

void TaskRefundPay::packageServerReq()
{
    QJsonArray transIds;
    if (!getPosJsonValue(PosProps.TransId).toString().isEmpty()) {
        transIds.append(getPosJsonValue(PosProps.TransId));
    }
    transIds.append(getPosJsonValue(PosProps.Fm_transId));
    QJsonObject transData;
    transData["transIds"] = transIds;

    serverReqJsonObj["data"] = transData;
}

void TaskRefundPay::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    foreach(auto prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}

TaskRefundOrder::TaskRefundOrder(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Refund_Order, 0, parent)
{

}

void TaskRefundOrder::packageServerReq()
{
    QJsonObject transData;
    QString fm_id = getPosJsonValue(PosProps.Fm_id).toString();
    QString fm_open_id = getPosJsonValue(PosProps.Fm_open_id).toString();
    QString trans_id =  getPosJsonValue(PosProps.TransId).toString();
    QString fm_transId =  getPosJsonValue(PosProps.Fm_transId).toString();

    if(fm_id == "") {
        if(fm_transId!="") {
            fm_id = FMBackup::instance()->getOrderByFMTransId(trans_id).fm_id;
            if(fm_id == "") {
                fm_id = fm_transId;
            }
        }
        if(fm_open_id!="" && trans_id!="") {
            fm_id = FMBackup::instance()->getOrderByTransId(trans_id).fm_id;
        }
    }
    transData[ServerProps(PosProps.Fm_id)] = fm_id;
    serverReqJsonObj["data"] = transData;
}

void TaskRefundOrder::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);

    foreach(auto prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    QString fm_id = getPosJsonValue(PosProps.Fm_id).toString();
    QString fmTransId = getPosJsonValue(PosProps.Fm_transId).toString();
    if(fm_id == "" && !fmTransId.isEmpty() && getServerJsonValue(ServerProps(PosProps.StatusCode)).toInt() == 3201) {
        posRspJsonObj[PosProps.StatusCode] = 100;
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}
