﻿#include "tasklogin.h"
#include "fmviplogin.h"
#include "fmp_vip_settings.h"
#include "fmnetwork.h"
#include <QJsonDocument>

TaskLogin::TaskLogin(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, FM_Login, session, parent)
{
}

TaskLogin::~TaskLogin()
{
    del_p(_window);
}

void TaskLogin::setWindow()
{
    _window = new FMVipLogin;

    connect(qobject_cast<FMVipLogin*>(_window), &FMVipLogin::login, this, &TaskLogin::onLogin);
    session()->addData("store_id", getPosJsonValue("store_id"));
    session()->addData("pos_id", getPosJsonValue("pos_id"));
    session()->addData("operator_id", getPosJsonValue("operator_id"));
    session()->addData("business_date", getPosJsonValue("business_date"));
}

void TaskLogin::packageServerReq()
{
    QJsonObject code;
    QString memberSign = session()->data(PosProps.Member_sign).toString();
    // 原生卡前加上"cardNo="标志给服务端
    if(memberSign.length() == 6) {
        memberSign = "cardNo="+memberSign;
    }
    code[ServerProps(PosProps.Member_sign)] = memberSign;
    serverReqJsonObj["data"] = code;
}

void TaskLogin::packagePOSRsp()
{
    int statusCode = getServerJsonValue("statusCode").toInt();
    posRspJsonObj["statusCode"] = statusCode == 2003 ? 100 : statusCode;
    posRspJsonObj["msg"] = getServerJsonValue("msg").toString();
    posRspJsonObj["prompt"] = getServerJsonValue("prompt").toInt();
    posRspJsonObj["fm_open_id"] = getServerJsonValue(PosProps.Fm_open_id).toString();
    posRspJsonObj["account"] = getServerJsonValue("memberNo").toString();
    posRspJsonObj["type_code"] = getServerJsonValue("typecode").toString();
    posRspJsonObj["type_name"] = getServerJsonValue("typename").toString();
    posRspJsonObj["amount"] = getServerJsonValue("amount").toInt();
    posRspJsonObj["score"] = getServerJsonValue("score").toInt();
    posRspJsonObj["name"] = getServerJsonValue("name").toString();
    posRspJsonObj["sex"] = getServerJsonValue("sex").toString();
    posRspJsonObj["birthday"] = getServerJsonValue("birthday").toString();
    QString phone = getServerJsonValue("mobile").toString();
    if(phone.isEmpty()) {
        phone = session()->data(PosProps.Phone).toString();
    }
    posRspJsonObj["phone"] = phone;
    posRspJsonObj["address"] = getServerJsonValue("address").toString();
    posRspJsonObj["email"] = getServerJsonValue("email").toString();
    posRspJsonObj[PosProps.Member_sign] = session()->data(PosProps.Member_sign).toString();

    posRspJsonObj["memberDiscount"] = getServerJsonValue("memberDiscount").toDouble(1.00);
}

void TaskLogin::onLogin()
{
    bool isOk = sendToServer();
    if(!isOk) {
        if(_window != nullptr) {
            _window->accept();
        }
        return;
    }

    int status = getServerJsonValue("statusCode").toInt();
    // 认证失败
    if(status == 2003) {
        session()->addData("statusCode", status);
        session()->addData(PosProps.Phone, session()->data(PosProps.Member_sign).toString());
        _window->accept();
        return;
    }else if(status != FM_API_SUCCESS) {
        QString info = serverRspJsonObj["msg"].toString();
        FMP_WARN() << "Login failed: " << info;
        FMMsgWnd::FailureWnd(info, _window);
    }
    // 认证成功
    else {
        QString account = getServerJsonValue(PosProps.Fm_open_id).toString();
        QString birthday = getServerJsonValue(PosProps.Birthday).toString();
        QString name = getServerJsonValue(PosProps.Name).toString();
        double amount = getServerJsonValue(PosProps.Amount).toInt()/100.0;
        int score = getServerJsonValue(PosProps.Score).toInt();
        QString amountStr = QString::number(amount, 'f', 2);
        QString scoreStr = QString::number(score);

        bool canPay = (getServerJsonValue(PosProps.CanPay).toInt() == 1);
        if(!canPay) {
            if(getPosJsonValue(PosProps.Fm_cmd).toInt() != FM_Pay) {
                QString info = QString::fromLocal8Bit("账号: %1\n姓名: %2\n余额: %3\n积分: %4").arg(account, name, amountStr, scoreStr);
                FMMsgWnd::SuccessWnd(info, _window);
//                FMMsgWnd::LoginSuccess(account, name, amountStr, scoreStr, _window);
            } else {
                FMMsgWnd::FailureWnd(QString::fromLocal8Bit(ErrorNeedPayCode), _window);
                _window->resetWnd();
                return;
            }
        }

        session()->addData(PosProps.Name, name);
        session()->addData(PosProps.Birthday, birthday);
        session()->addData(PosProps.Fm_open_id, account);
        session()->addData(PosProps.Amount, getServerJsonValue(PosProps.Amount).toInt());
        session()->addData(PosProps.Score, getServerJsonValue(PosProps.Score).toInt());
        session()->addData(PosProps.CanPay, canPay);

        _window->accept();
    }
    if(_window!=nullptr) {
        _window->resetWnd();
    }
}
