﻿#include "taskfinal.h"
#include "fmbackup.h"
#include "fmnetwork.h"
#include "fmp_logger_i.h"
#include "fmmsgwnd.h"
#include "fmp_vip_settings.h"
#include <QDateTime>
#include <QJsonDocument>
#include <QJsonArray>
#include <QCryptographicHash>

TaskFinal::TaskFinal(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Final, session, parent)
{
}

void TaskFinal::packageServerReq()
{
    QJsonObject transData;
    std::vector<QString> p;
    p.push_back(PosProps.BussinessDate);
    p.push_back(PosProps.TransId);
    p.push_back(PosProps.Fm_id);
    p.push_back(PosProps.Fm_open_id);
    p.push_back(PosProps.OrderAmount);
    p.push_back(PosProps.PaidAmount);
    foreach(auto prop , p) {
        transData[ServerProps(prop)] = getPosJsonValue(prop);
    }

    int orderAmount = getPosJsonValue(PosProps.OrderAmount).toDouble();

    if (transData[ServerProps(PosProps.PaidAmount)].toInt() == 0) {
        transData[ServerProps(PosProps.PaidAmount)] = orderAmount;
    }

    // 产品列表
    QJsonArray products;
    foreach(auto p , getPosJsonValue("products").toArray())
    {
        QJsonObject product;
        product[ServerProps(PosProps.ConsumeNum)] = p.toObject()["consume_num"];
        int price = p.toObject()["price"].toDouble()*100;
        product["price"] = price;
        product["productId"] = p.toObject()["pid"];
        
        products.append(product);
    }
    transData["productList"] = products;

    int payTotalAmount = 0;
    QJsonArray payList;
    foreach(auto p, getPosJsonValue(PosProps.Pay_ids).toArray())
    {
        QJsonObject pay;
        int payAmount = p.toObject()["pay_amount"].toDouble();
        payTotalAmount += payAmount;
        pay["amount"] = payAmount;
        pay["thirdPayTransId"] = p.toObject()["pay_transId"].toString();
        pay["code"] = p.toObject()["code"].toString();
        pay[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);
        QString typeModeFlag = p.toObject()["pay_id"].toString();
        if(typeModeFlag == "0101") {
            //现金支付
            pay["typeModeFlag"] = "20005";
        } else if (typeModeFlag == "0103") {
            pay["typeModeFlag"] = "20010";
        } else if(typeModeFlag == "0301") {
            pay["typeModeFlag"] = "10011";
        } else if(typeModeFlag == "0302") {
            pay["typeModeFlag"] = "10011";
        } else if(typeModeFlag == "0303") {
            pay["typeModeFlag"] = "10011";
        } else {
            pay["typeModeFlag"] = typeModeFlag;
        }
        
        payList.append(pay);
    }
    if(payTotalAmount < orderAmount) {
        QJsonObject cashPay;
        cashPay["amount"] = orderAmount-payTotalAmount;
        cashPay[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);
        cashPay["typeModeFlag"] = "20005";
        payList.append(cashPay);
    }

    transData["payList"] = payList;
    serverReqJsonObj["data"] = transData;
}

bool TaskFinal::sendToServer(bool isShowMsg)
{
    Q_UNUSED(isShowMsg);
    FMTask::sendToServer(false);
    
    // 备份
    if(error() == FM_API_NETWORERROR) {
        if(searchJsonValue(serverReqJsonObj,ServerProps(PosProps.CodeAmount)).toInt() == 0 &&
           searchJsonValue(serverReqJsonObj,ServerProps(PosProps.ScoreAmount)).toInt() == 0 &&
           searchJsonValue(serverReqJsonObj,ServerProps(PosProps.Coupons)).toArray().isEmpty()) {
            QString fm_id = backup();
            if(!fm_id.isEmpty()){
                setError(FM_API_SUCCESS);
                serverRspJsonObj[ServerProps(PosProps.StatusCode)] = FM_API_SUCCESS;
                serverRspJsonObj[ServerProps(PosProps.Msg)] = QString::fromLocal8Bit("结算成功");
                serverRspJsonObj[ServerProps(PosProps.Fm_id)] = fm_id;
                serverRspJsonObj[ServerProps(PosProps.Prompt)] = 1;
                serverRspJsonObj[ServerProps(PosProps.Print1)] = "";
                serverRspJsonObj[ServerProps(PosProps.Print2)] = "";
            }
        }
    }
    bool isOk = (error() == FM_API_SUCCESS);
    if(!isOk)
    {
        FMMsgWnd::FailureWnd(errorString(), nullptr);
    }
    return isOk;
}

void TaskFinal::packagePOSRsp()
{
    int status = getServerJsonValue(PosProps.StatusCode).toInt();
    posRspJsonObj[PosProps.StatusCode] = status;
    posRspJsonObj[PosProps.Msg] = getServerJsonValue(PosProps.Msg);
    posRspJsonObj[PosProps.Prompt] = 1;

    if(status == FM_API_SUCCESS) {
        QString trans_id = getPosJsonValue(PosProps.TransId).toString();
        QString fm_open_id = getServerJsonValue(PosProps.Fm_open_id).toString();
        QString fm_id = getServerJsonValue(PosProps.Fm_id).toString();
        QString fm_transId = "";

        foreach(auto p, getServerJsonValue(PosProps.Pay_ids).toArray())
        {
            QJsonObject pay = p.toObject();
            QString typeModeFlag = pay["typeModeFlag"].toString();
            if (typeModeFlag == "20010") {
                fm_transId = pay["thirdPayTransId"].toString();
            }
        }
        FMBackup::instance()->insertNewOrder(trans_id, fm_open_id, fm_id, fm_transId);
    }
}

QString TaskFinal::backup()
{
    int newId = FMBackup::instance()->insertNewRow();
    QString uuid = QString("E%1%2%3%4")
            .arg(getPosJsonValue(PosProps.StoreId).toString())
            .arg(getPosJsonValue(PosProps.PosId).toString().toInt(), 2, 10, QChar('0'))
            .arg(QDateTime::currentDateTime().toString("yyMMdd"))
            .arg(newId, 5, 10, QChar('0'));
    QJsonDocument json(serverReqJsonObj);
    bool isOk = FMBackup::instance()->updateReqData(newId, this->url, json.toJson(QJsonDocument::Compact));
    if(isOk && uuid.length()==20) {
        return uuid;
    }
    return "";
}
