﻿#include "fmnetwork.h"
#include "global.h"
#include "fmp_vip_settings.h"
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QEventLoop>
#include <QTimer>
#include <QSettings>

FMNetwork::FMNetwork(QObject *parent) :
    QObject(parent),
    error(FM_API_SUCCESS),
    _nam(new QNetworkAccessManager),
    _req(new QNetworkRequest)
{

}

FMNetwork::~FMNetwork()
{
    del_p(_nam);
    del_p(_req);
}

int FMNetwork::send(const QString &url, const QByteArray &reqData, QByteArray &rspData)
{
    error = FM_API_SUCCESS;

    FMP_INFO() << "Send Url: " << url;
    FMP_INFO() << "Send Data: " << reqData;

    _req->setUrl(url);

    // 设置请求头
    _req->setHeader(QNetworkRequest::ContentTypeHeader, "application/json");
    _req->setHeader(QNetworkRequest::ContentLengthHeader, reqData.length());

    auto reply = _nam->post(*_req, reqData);

    // 使用定时器处理超时
    QEventLoop loop;
    connect(_nam, SIGNAL(finished(QNetworkReply*)), &loop, SLOT(quit()));
    QTimer timer;
    timer.setSingleShot(true);
    connect(&timer, SIGNAL(timeout()),&loop,SLOT(quit()));
    timer.start(1000 * 60);
    loop.exec();

    if(timer.isActive())
    {
        timer.stop();
        if (reply->error() == QNetworkReply::NoError) {
            rspData = reply->readAll();
        } else {
            int err = reply->error();
            rspData = reply->readAll();
            error = FM_API_NETWORERROR;
            errorMsg = QString("NetworkError(%1)").arg(err);
        }
    }else{
        error = FM_API_TIMEOUT;
    }
    return error;
}

QString FMNetwork::netErrInfo(int code)
{
    QSettings setting(AppDirPath+"/FMVip.cfg", QSettings::IniFormat);
    setting.setIniCodec("GBK");
    setting.beginGroup("NetworkError");
    QString key = QString::number(code);
    if(!setting.contains(key)) {
        key = "default";
    }
    QString errInfo = setting.value(key).toString();
    setting.endGroup();
    return errInfo;
}
