#ifndef FMBACKUP_H
#define FMBACKUP_H
#include <QSqlDatabase>
#include <QSqlRecord>

class FMBackup
{
public:
    typedef struct {
        QString trans_id;
        QString fm_open_id;
        QString fm_id;
        QString fm_transId;
    } FMOrder;


    static FMBackup* instance();
    bool updateReqData(const int id, const QString url, const QString &reqData);
    bool removeReqData(const int &id);
    int insertNewRow();
    bool insertNewOrder(const QString &trans_id, const QString &fm_open_id, const QString &fm_id, const QString &fm_transId);
    FMOrder getOrderByTransId(const QString &trans_id);
    FMOrder getOrderByFMTransId(const QString &fm_transId);

    QSqlQuery reqDataQuery() const;
    bool reset();
private:
    FMBackup();
    static FMBackup* _instance;
    QSqlDatabase _db;


    bool connect();
    bool createTable(const QString &dbname);

private:
    class privateFMBackup
    {
    public:
        ~privateFMBackup()
        {
            if(FMBackup::_instance != nullptr) {
                delete FMBackup::_instance;
                FMBackup::_instance = nullptr;
            }
        }
    };
};

#endif // FMBACKUP_H
