﻿#include "fmbackup.h"
#include "fmp_vip_settings.h"
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QSqlError>
#include <QDir>
#include <QFile>
#include <QApplication>
#include <QDebug>

FMBackup* FMBackup::_instance = nullptr;

FMBackup::FMBackup()
{
    connect();
}

FMBackup* FMBackup::instance()
{
    if(_instance == nullptr) {
        _instance = new FMBackup();
    }
    return _instance;
}

bool FMBackup::connect()
{
    bool isOk;
    QString backupPath = qApp->applicationDirPath()+"/backup/";
    QDir dir;
    if(!dir.exists(backupPath)) {
        dir.mkdir(backupPath);
    }
    QString dbname = backupPath + "backupReq.db";
    if(!QFile::exists(dbname)) {
        isOk = createTable(dbname);
    } else {
        _db = QSqlDatabase::addDatabase("QSQLITE", "fmvipbackupdb");
        _db.setDatabaseName(dbname);
        isOk =_db.open();
    }

    FMP_INFO() << QString::fromLocal8Bit("连接数据库：") << dbname;
    if(!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("连接失败：") << _db.lastError().text();
    }

    return isOk;
}

bool FMBackup::createTable(const QString &dbname)
{
    _db = QSqlDatabase::addDatabase("QSQLITE", "fmvipbackupdb");
    _db.setDatabaseName(dbname);
    _db.open();
    QSqlQuery query(_db);
    //  创建表
    bool isOk = query.exec("create table tbl_req(id integer PRIMARY KEY autoincrement, url varchar(200), req text)");
    isOk &= query.exec("create table tbl_order(id integer PRIMARY KEY autoincrement, trans_id varchar(10), fm_open_id varchar(10), fm_id varchar(20), fm_transId varchar(30))");

    FMP_INFO() << QString::fromLocal8Bit("创建数据库：") << dbname;
    if (!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("创建数据库失败：") << query.lastError().text();
    }
    return isOk;
}

int FMBackup::insertNewRow()
{
    if(!_db.isOpen()) {
        connect();
    }
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("insert into tbl_req('url','req') values('','');"));
    isOk &= query.exec("select last_insert_rowid();");

    int id = -1;
    if(isOk && query.next()) {
        id = query.record().value(0).toInt();
    }

    return id;
}

bool FMBackup::updateReqData(const int id, const QString url, const QString &reqData)
{
    if(!_db.isOpen()) {
        connect();
    }
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("update tbl_req set url = '%1', req='%2' where id=%3")
                           .arg(url)
                           .arg(reqData)
                           .arg(id));

    FMP_INFO() << QString::fromLocal8Bit("备份数据：") << reqData;
    if (!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("备份失败：") << query.lastError().text();
    }
    return isOk;
}

bool FMBackup::removeReqData(const int &id)
{
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("delete from tbl_req where id==%1").arg(id));
    if(!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("删除数据时出现错误：") << query.lastError().text();
    }
    return isOk;
}

QSqlQuery FMBackup::reqDataQuery() const
{
    QSqlQuery query(_db);
    bool isOk = query.exec("select * from tbl_req");
    if(!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("查询数据时出现错误：") << query.lastError().text();
    }
    return query;
}

bool FMBackup::reset()
{
    QSqlQuery query(_db);
    bool isOk = query.exec("VACUUM");
    FMP_INFO() << QString::fromLocal8Bit("数据库重置: ") << isOk;
    return isOk;
}

bool FMBackup::insertNewOrder(const QString &trans_id, const QString &fm_open_id, const QString &fm_id, const QString &fm_transId)
{
    if(!_db.isOpen()) {
        connect();
    }
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("insert into tbl_order('trans_id','fm_open_id','fm_id','fm_transId') values('%1','%2','%3','%4');")
                           .arg(trans_id).arg(fm_open_id).arg(fm_id).arg(fm_transId));
    if(!isOk) {
        FMP_ERROR() << QString::fromLocal8Bit("插入订单数据失败：trans_id: %1, fm_open_id: %2, fm_id: %3, fm_transId: %4。失败原因：%5")
                       .arg(trans_id).arg(fm_open_id).arg(fm_id).arg(fm_transId).arg(query.lastError().text());
    }
    return isOk;
}

FMBackup::FMOrder FMBackup::getOrderByTransId(const QString &trans_id)
{
    if(!_db.isOpen()) {
        connect();
    }

    QSqlQuery query(_db);
    bool isOk = query.exec(QString("select * from tbl_order where (tbl_order.trans_id='%1')").arg(trans_id));
    if(!isOk) {
        FMP_ERROR() << QString::fromLocal8Bit("查询订单失败：trans_id: %1。失败原因：%2").arg(trans_id).arg(query.lastError().text());
    }
    FMOrder order;
    while(query.next())
    {
        QSqlRecord record = query.record();
        order.trans_id = record.value("trans_id").toString();
        order.fm_open_id = record.value("fm_open_id").toString();
        order.fm_id = record.value("fm_id").toString();
        order.fm_transId = record.value("fm_transId").toString();
    }
    FMP_INFO() << QString::fromLocal8Bit("查询到订单信息：trans_id: %1, fm_open_id: %2, fm_id: %3, fm_transId: %4。")
                  .arg(order.trans_id).arg(order.fm_open_id).arg(order.fm_id).arg(order.fm_transId);
    return order;
}

FMBackup::FMOrder FMBackup::getOrderByFMTransId(const QString &fm_transId)
{
    if(!_db.isOpen()) {
        connect();
    }

    QSqlQuery query(_db);
    bool isOk = query.exec(QString("select * from tbl_order where (tbl_order.fm_transId='%1')").arg(fm_transId));
    if(!isOk) {
        FMP_ERROR() << QString::fromLocal8Bit("查询订单失败：fm_transId: %1。失败原因：%2").arg(fm_transId).arg(query.lastError().text());
    }
    FMOrder order;
    while(query.next())
    {
        QSqlRecord record = query.record();
        order.trans_id = record.value("trans_id").toString();
        order.fm_open_id = record.value("fm_open_id").toString();
        order.fm_id = record.value("fm_id").toString();
        order.fm_transId = record.value("fm_transId").toString();
    }
    FMP_INFO() << QString::fromLocal8Bit("查询到订单信息：trans_id: %1, fm_open_id: %2, fm_id: %3, fm_transId: %4。")
                  .arg(order.trans_id).arg(order.fm_open_id).arg(order.fm_id).arg(order.fm_transId);
    return order;
}
