﻿#include "taskpay.h"
#include "tasklogin.h"
#include "fmviporder.h"
#include "fmp_logger_i.h"
#include "fmp_vip_settings.h"
#include "fmnetwork.h"
#include "fmbackup.h"
#include <QJsonDocument>
#include <QJsonObject>
#include <QCryptographicHash>

TaskPay::TaskPay(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, FM_Pay, session, parent)
{
}

QByteArray TaskPay::doTask()
{    
    FMP_DEBUG() << __FUNCTION__;

    QString fm_open_id_pos = getPosJsonValue(PosProps.Fm_open_id).toString();
    QString fm_open_id_session = session()->data(PosProps.Fm_open_id).toString();
    if(fm_open_id_session == "" || fm_open_id_pos!=fm_open_id_session || session()->data(PosProps.CanPay).toBool() == false) {
        preTask = new TaskLogin(posReqJsonObj, _session, this);
        preTask->session()->addData(PosProps.FM_Type, FM_Pay);
        QByteArray loginRst = preTask->doTask();
        if(preTask->error() != FM_API_SUCCESS) {
            return loginRst;
        }
        this->_session = preTask->session();
    }

    session()->addData(PosProps.OrderAmount, getPosJsonValue(PosProps.OrderAmount).toInt());
    session()->addData(PosProps.PaidAmount, getPosJsonValue(PosProps.PaidAmount).toInt());
    session()->addData(PosProps.UndisAmount, getPosJsonValue(PosProps.UndisAmount).toInt());

    couponThread = new TaskCouponThread(posReqJsonObj, _session, this);
    couponThread->start();
    connect(couponThread, SIGNAL(finished(Session*)), SLOT(onGetCoupons(Session*)));
    return FMTask::doTask();
}

void TaskPay::onGetCoupons(Session* session)
{
    couponThread->exit();

    _session->addData(PosProps.CouponMap, session->getCouponMap(PosProps.CouponMap));
    if(_window != nullptr) {
        qobject_cast<FMVipOrder*>(_window)->initCouponItems();
        _window->setIsBusy(false);
        _window->setEnabled(true);
    }
}

void TaskPay::setWindow()
{
    _window = new FMVipOrder;

    connect(qobject_cast<FMVipOrder*>(_window), SIGNAL(pay()), this, SLOT(onPay()));
}

void TaskPay::packageServerReq()
{
    //! 会员新接口使用 data 打包业务数据
    QJsonObject transData;
    transData[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);

    transData[ServerProps(PosProps.Fm_id)] = getPosJsonValue(PosProps.Fm_id);
    transData[ServerProps(PosProps.Fm_id)] = "";
    transData[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();

    QJsonArray products;
    QJsonArray clientArray = getPosJsonValue("products").toArray();
    for(int i = 0; i < clientArray.size(); i++)
    {
        QJsonObject obj = clientArray[i].toObject();
        QJsonObject serverObj;
        serverObj[ServerProps(PosProps.ConsumeNum)] = obj[PosProps.ConsumeNum];
        int price = obj["price"].toInt();
        serverObj["price"] = price;
        serverObj["productId"] = obj["pid"];
        products.push_back(serverObj);
    }

    QJsonArray payList;
    //余额支付详情
    QJsonObject balance;
    int codeAmount = session()->data(PosProps.CodeAmount).toInt();
    balance["amount"] = codeAmount;
    balance["transId"] = getPosJsonValue("trans_id");
    balance["typeModeFlag"]  = 20001;
    balance["thirdPayTransId"] = "";
    payList.push_back(balance);

    // 积分支付详情
    QJsonObject score;
    int scoreAmount = session()->data(PosProps.ScoreAmount).toInt();
    if(scoreAmount > 0) {
        score["amount"] = scoreAmount;
        score["transId"] = getPosJsonValue("trans_id");
        score["typeModeFlag"] = 20002;
        score["thirdPayTransId"] = "";
        payList.push_back(score);
    }


    //代金券/商品券支付详情
    QMap<QString, QVariant> coupons = session()->data("payCouponMap").toMap();
    // 将代金券按金额从小到大排序
    QList<Coupon> couponList;
    for(QMap<QString, QVariant>::const_iterator it = coupons.constBegin(); it != coupons.constEnd(); it++)
    {
        couponList.append(it.value().value<Coupon>());
    }
    qSort(couponList.begin(), couponList.end(), [=](const Coupon &first, const Coupon &second){
        return (first.disAmount() < second.disAmount());
    });
    // 计算使用的代金券金额

    int needAmount = session()->data(PosProps.NeedAmount).toInt();
    int needCouponAmount = needAmount - codeAmount - scoreAmount;
    int couponAmount = 0;
    foreach(Coupon c, couponList)
    {
        if(needCouponAmount <= 0) {
            break;
        }
        QJsonObject coupon;
        int couponDisAmount = c.disAmount() * 100;
        if(couponDisAmount <= needCouponAmount) {
            couponDisAmount = couponDisAmount;
            needCouponAmount -= couponDisAmount;
        } else {
            couponDisAmount = MAX(0, needCouponAmount);
            needCouponAmount = 0;
        }
        couponAmount += couponDisAmount;
        coupon["amount"] = couponDisAmount;

        coupon["transId"] = getPosJsonValue(PosProps.TransId);
        coupon["typeModeFlag"] = 20003;
        coupon["code"] = c.code();
        payList.push_back(coupon);
    }

    transData["productList"] = products;
    transData["payList"] = payList;
    int payAmount = codeAmount + scoreAmount + couponAmount;
    transData[ServerProps(PosProps.Pay_amount)] = payAmount;

    serverReqJsonObj["data"] = transData;
}

void TaskPay::packagePOSRsp()
{
    posRspJsonObj[PosProps.StatusCode] = getServerJsonValue(PosProps.StatusCode);
    posRspJsonObj[PosProps.Msg] = getServerJsonValue(PosProps.Msg);
    posRspJsonObj[PosProps.Prompt] = 0;
    posRspJsonObj[PosProps.Settlement] = 1;
    posRspJsonObj[PosProps.Fm_open_id] = session()->data(PosProps.Fm_open_id).toString();
    posRspJsonObj[PosProps.Fm_id] = getServerJsonValue(PosProps.Fm_id).toString();
    posRspJsonObj[PosProps.Fm_transId] = getServerJsonValue(PosProps.TransId).toString();

    QJsonArray servPayArray = getServerJsonValue("payList").toArray();
    //支付方式描述
    QMap<QString, QString> description;
    description["20001"] = QString::fromLocal8Bit("会员储值金支付");
    description["20002"] = QString::fromLocal8Bit("会员积分支付");
    description["20003"] = QString::fromLocal8Bit("代金券支付");
    description["20004"] = QString::fromLocal8Bit("商品券支付");
    description["20005"] = QString::fromLocal8Bit("现金支付");

    //计算总支付额
    QJsonArray pay_ids;
    int totalPaid = 0;
    for(int i = 0; i < servPayArray.size(); i++)
    {
        QJsonObject pay_id;
        QString payId = servPayArray[i].toObject()[ServerProps(PosProps.Pay_id)].toString();
        if(payId == "20003") {
            pay_id[PosProps.Pay_amount] = 0;
            pay_id["merchant_discount"] = servPayArray[i].toObject()[ServerProps(PosProps.Pay_amount)].toInt();
        } else {
            pay_id[PosProps.Pay_amount] = servPayArray[i].toObject()[ServerProps(PosProps.Pay_amount)].toInt();
        }
        pay_id[PosProps.Pay_id] = payId;
        pay_id[PosProps.Pay_str] = description[servPayArray[i].toObject()["typeModeFlag"].toString()];
        pay_id[PosProps.Coupon_code] = servPayArray[i].toObject()["code"].toString();
        pay_ids.push_back(pay_id);

        totalPaid += pay_id[PosProps.Pay_amount].toInt();
    }
    posRspJsonObj[PosProps.Paid_total_amount] = totalPaid;
    posRspJsonObj[PosProps.Pay_ids] = pay_ids;

//    if(getServerJsonValue(PosProps.StatusCode) == FM_API_SUCCESS)
//    {
//        QJsonDocument json(serverRspJsonObj);
//        QByteArray orderContent = json.toJson(QJsonDocument::Compact);
//        FMBackup::instance()->insertNewOrder(getServerJsonValue(PosProps.Fm_id).toString(), orderContent);
//    }
}

void TaskPay::onPay()
{
    sendToServer();

    if(error() == FM_API_TIMEOUT) {
        FMP_INFO() << "Pay failed: timeout. To reversal.";
        TaskRefundPay taskRefundPay(posReqJsonObj);
        taskRefundPay.doTask();
    }

    _window->accept();
}
