﻿#include "taskothers.h"

TaskCoupon::TaskCoupon(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Coupon, session, parent)
{

}

void TaskCoupon::packageServerReq()
{
    QJsonObject data;
    data[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();
//    data[ServerProps(PosProps.Fm_open_id)] = "6524402960";
    // 产品列表
    QJsonArray propducts;
    foreach(QJsonValue pValue, getPosJsonValue(PosProps.Products).toArray())
    {
        QJsonObject po = pValue.toObject();
        QJsonObject spo;
        spo["product_code"] = po[PosProps.ProductId];
        spo["quantity"] = po[PosProps.ConsumeNum];
        spo[ServerProps(PosProps.Price)] = po[PosProps.Price];
        spo["category_code"] = "";
        propducts.append(spo);
    }
    data[ServerProps(PosProps.Products)] = propducts;
    serverReqJsonObj["data"] = data;
}

void TaskCoupon::packagePOSRsp()
{
    int canDisAmount = session()->data(PosProps.OrderAmount).toInt() - session()->data(PosProps.PaidAmount).toInt() - session()->data(PosProps.UndisAmount).toInt();

    QMap<QString, QVariant> couponMap;
    foreach (auto value, getServerJsonValue(PosProps.CouponList).toArray())
    {
        QJsonObject couponOb = value.toObject();
        QString code = couponOb[ServerProps(PosProps.Coupon_code)].toString();
        double amount = couponOb[ServerProps(PosProps.Coupon_disAmount)].toInt() / 100.0;
        QString desc = couponOb["active_name"].toString();
        int type = couponOb[ServerProps(PosProps.Coupon_type)].toInt();
        QString limitTime = couponOb["expiration_date"].toString();

        Coupon c(desc, code, QString::number(type), amount, 0, limitTime, false);
        QVariant v;
        v.setValue(c);
        couponMap[code] = v;
    }
    session()->addData(PosProps.CouponMap, couponMap);
}

TaskRefundPay::TaskRefundPay(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Refund_Pay, 0, parent)
{

}

void TaskRefundPay::packageServerReq()
{
    QJsonArray transIds;
    transIds.append(getPosJsonValue(PosProps.TransId));
    QJsonObject transData;
    transData["transIds"] = transIds;

    serverReqJsonObj["data"] = transData;
}

void TaskRefundPay::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    foreach(auto prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}

TaskRefundOrder::TaskRefundOrder(QJsonObject &jsonObj, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Refund_Order, 0, parent)
{

}

void TaskRefundOrder::packageServerReq()
{
    QJsonObject transData;
    transData[ServerProps(PosProps.Fm_id)] = getPosJsonValue(PosProps.Fm_id);
    transData[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);
    serverReqJsonObj["data"] = transData;
}

void TaskRefundOrder::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    foreach(auto prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(ServerProps(prop));
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}
